<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class VSRPB_License_Manager {

    const OPTION_KEY = 'vserpb_addon_licenses';
    private static $addons = [];

    public static function register_addon( array $args ) {
        self::$addons[ $args['slug'] ] = $args;
    }

    public static function init() {
        add_action( 'admin_init', [ __CLASS__, 'handle_form' ] );
             add_action('admin_enqueue_scripts', array(__CLASS__, 'enqueue_assets'));
    }

public static function enqueue_assets() {

    wp_enqueue_style(
        'vserpb-license-manager',
        plugin_dir_url(dirname(__FILE__)) . 'assets/css/vserpb-license-admin.css',
        array(),
        filemtime(plugin_dir_path(dirname(__FILE__)) . 'assets/css/vserpb-license-admin.css')
    );


}

   public static function handle_form() {

    if (
        ! isset( $_POST['_wpnonce'] ) ||
        ! wp_verify_nonce( $_POST['_wpnonce'], 'vserpb_license_save' ) ||
        ! current_user_can( 'manage_options' )
    ) {
        return;
    }

    $data = get_option( self::OPTION_KEY, [] );

    foreach ( self::$addons as $slug => $addon ) {

        if ( ! isset( $data[$slug] ) || ! is_array( $data[$slug] ) ) {
            $data[$slug] = [];
        }

        // Remove license
        if ( isset( $_POST['deactivate'][ $slug ] ) ) {

            $data[$slug]['purchase_code'] = '';
            $data[$slug]['token']         = '';

            $data[$slug]['status']        = 'inactive';
            $data[$slug]['valid']         = false;
            $data[$slug]['message']       = '';
            $data[$slug]['activated_at']  = 0;
            $data[$slug]['last_checked']  = 0;
            $data[$slug]['updated']       = time();

            continue;
        }

        // Save fields
        $purchase_code = sanitize_text_field( $_POST['purchase_code'][$slug] ?? '' );
        $token         = sanitize_text_field( $_POST['token'][$slug] ?? '' );

        $data[$slug]['purchase_code'] = $purchase_code;
        $data[$slug]['token']         = $token;

        /**
         * IMPORTANT:
         * Basic plugin DOES NOT call API.
         * It just sets "checking" so Pro plugin can verify and update.
         */
        if ( ! empty($purchase_code) && ! empty($token) ) {
            $data[$slug]['status']  = 'checking';
            $data[$slug]['message'] = 'Checking license...';
        } else {
            $data[$slug]['status']  = 'inactive';
            $data[$slug]['message'] = '';
        }

        $data[$slug]['updated'] = time();


        do_action( 'vserpb_license_saved', $slug );
    }

    update_option( self::OPTION_KEY, $data );

    wp_redirect( add_query_arg( 'updated', 'true' ) );
    exit;
}



   public static function render_page() {

    $licenses = get_option( self::OPTION_KEY, [] );
    ?>
    <div class="wrap vserpb-license-page">
        <h1 class="wp-heading-inline">Voidek Add-on Licenses</h1>
        <p class="description">
            Activate premium add-ons using your Envato purchase code and personal token.
        </p>

        <form method="post">
            <?php wp_nonce_field( 'vserpb_license_save' ); ?>

            <div class="vserpb-license-grid">

                <?php foreach ( self::$addons as $slug => $addon ) :

                   $purchase = $licenses[$slug]['purchase_code'] ?? '';
$token    = $licenses[$slug]['token'] ?? '';

$status       = $licenses[$slug]['status'] ?? 'inactive';
$message      = $licenses[$slug]['message'] ?? '';
$activated_at = $licenses[$slug]['activated_at'] ?? 0;
$last_checked = $licenses[$slug]['last_checked'] ?? 0;

$is_active   = ($status === 'active');
$is_invalid  = ($status === 'invalid');
$is_checking = ($status === 'checking');

                ?>
                <div class="vserpb-license-card">

                    <div class="vserpb-card-header">
                        <h2><?php echo esc_html( $addon['name'] ); ?></h2>
                        <span class="vserpb-badge">PRO</span>
                    </div>

                 <div class="vserpb-card-body">

    <?php if ( $is_active ) : ?>

        <!-- ✅ ACTIVE STATE -->
        <div class="vserpb-license-status vserpb-status-active">

            <div class="vserpb-status-row">
                <span class="vserpb-status-pill">
                    <span class="vserpb-status-dot"></span>
                    License Activated
                </span>

                <?php if ( ! empty( $activated_at ) ) : ?>
                    <span class="vserpb-activated-date">
                        Activated on: <?php echo esc_html( date_i18n( 'd M Y, h:i A', $activated_at ) ); ?>
                    </span>
                <?php endif; ?>
            </div>

            <?php if ( ! empty($last_checked) ) : ?>
                <p class="vserpb-check-note">
                    Last checked: <?php echo esc_html( date_i18n( 'd M Y, h:i A', $last_checked ) ); ?>
                </p>
            <?php endif; ?>

            <div class="vserpb-actions">
                <button type="submit"
                        name="deactivate[<?php echo esc_attr( $slug ); ?>]"
                        class="button vserpb-btn-danger">
                    Remove License
                </button>
            </div>

        </div>

    <?php else : ?>

        <?php if ( $is_invalid ) : ?>
            <!-- ❌ INVALID STATE -->
            <div class="vserpb-license-status vserpb-status-invalid">
                <strong>License Invalid</strong>
                <div class="vserpb-error-text">
                    <?php echo esc_html( $message ?: 'Invalid purchase code or token.' ); ?>
                </div>
            </div>
        <?php endif; ?>

        <?php if ( $is_checking ) : ?>
            <!-- ⏳ CHECKING STATE -->
            <div class="vserpb-license-status vserpb-status-checking">
                <strong>Checking License...</strong>
                <div class="vserpb-checking-text">
                    <?php echo esc_html( $message ?: 'Please wait. License will be verified.' ); ?>
                </div>
            </div>
        <?php endif; ?>

        <!-- FIELDS -->
        <div class="vserpb-field">
            <label>Envato Purchase Code</label>
            <input type="text"
                   class="regular-text"
                   name="purchase_code[<?php echo esc_attr( $slug ); ?>]"
                   value="<?php echo esc_attr( $purchase ); ?>"
                   placeholder="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx">
            <p class="description">
                Found in your Envato downloads page.
            </p>
        </div>

        <div class="vserpb-field">
            <label style="display:flex;align-items:center;gap:8px;">
                Envato Personal Token
                <a href="https://build.envato.com/create-token/"
                   target="_blank"
                   class="button button-small"
                   style="padding:0 8px; line-height:24px; height:24px; border-radius:50%; font-weight:700;"
                   title="How to create Envato token">
                    i
                </a>
            </label>

            <input type="password"
                   class="regular-text"
                   name="token[<?php echo esc_attr( $slug ); ?>]"
                   value="<?php echo esc_attr( $token ); ?>"
                   placeholder="Envato personal token">

            <p class="description">
                Token must have permission to view purchases.
                <a href="https://build.envato.com/create-token/" target="_blank">Create token</a>
            </p>
        </div>

        <p style="margin-top:14px;">
            <button type="submit" class="button button-primary">
                Save & Verify
            </button>
        </p>

    <?php endif; ?>

</div>



                </div>
                <?php endforeach; ?>

            </div>
        </form>
    </div>
    <?php
}

}

VSRPB_License_Manager::init();
