<?php
/**
 * Class VSERPB_Ajax_Handler
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Prevent direct access.
}

/**
 * VSERPB_Ajax_Handler
 */
class VSERPB_Ajax_Handler {

	/**
	 * Initialize AJAX actions and scripts.
	 */
	public static function init() {
		add_action( 'wp_enqueue_scripts', array( __CLASS__, 'vserpb_enqueue_scripts' ) );
		add_action( 'admin_enqueue_scripts', array( __CLASS__, 'vserpb_enqueue_scripts' ) );
		add_action( 'wp_ajax_vserpb_update_product_schema', array( __CLASS__, 'vserpb_update_product_schema' ) );
		add_action( 'wp_ajax_asm_update_article_schema', array( __CLASS__, 'vserpb_update_article_schema' ) );
		
	}

	/**
	 * Enqueue admin scripts.
	 */
	public static function vserpb_enqueue_scripts() {
		if ( ! is_admin() ) {
			return;
		}

		wp_enqueue_script( 'vserpb-admin-js', VSERPB_PLUGIN_URL . 'assets/js/vserpb-admin.js', array( 'jquery' ), '1.0', true );
	$page = filter_input( INPUT_GET, 'page', FILTER_SANITIZE_FULL_SPECIAL_CHARS );

if ( 'voidek-serp-schema-builder' == $page ) {
	wp_enqueue_style(
		'vserpb-admin-css',
		VSERPB_PLUGIN_URL . 'assets/css/vserpb-admin.css',
		array(),
		'1.0.0'
	);
}

		wp_localize_script(
			'vserpb-admin-js',
			'vserpb_ajax_object',
			array(
				'ajax_url'   => admin_url( 'admin-ajax.php' ),
				'nonce'      => wp_create_nonce( 'vserpb_update_schema_nonce' ),
				'success'    => esc_html__( 'Product schema updated successfully!', 'voidek-serp-schema-builder' ),
				'error'      => esc_html__( 'Failed to update schema.', 'voidek-serp-schema-builder' ),
				'permission' => esc_html__( 'Permission denied.', 'voidek-serp-schema-builder' ),
				'invalid_id' => esc_html__( 'Invalid product ID.', 'voidek-serp-schema-builder' ),
			)
		);
	}

	/**
	 * Handle AJAX request to update product schema.
	 */
	public static function vserpb_update_product_schema() {
		// Check nonce for security
		check_ajax_referer( 'vserpb_update_schema_nonce', 'nonce' );

		if ( ! current_user_can( 'manage_options' ) ) {
			wp_send_json_error( esc_html__( 'Permission denied.', 'voidek-serp-schema-builder' ) );
		}

		$product_id = isset( $_POST['product_id'] ) ? intval( $_POST['product_id'] ) : 0;

		if ( ! $product_id ) {
			wp_send_json_error( esc_html__( 'Invalid product ID.', 'voidek-serp-schema-builder' ) );
		}

		$schema = Vserpb_Product_Schema::vserpb_generate_schema( $product_id );

		wp_send_json_success( $schema );
	}

	/**
	 * Handle AJAX request to update Article schema
	 */
	public static function vserpb_update_article_schema() {
		// Check nonce for security
		check_ajax_referer( 'asm_update_schema_nonce', 'nonce' );

		if ( ! current_user_can( 'manage_options' ) ) {
			wp_send_json_error( esc_html__( 'Permission denied.', 'voidek-serp-schema-builder' ) );
		}

		$post_id = isset( $_POST['post_id'] ) ? intval( $_POST['post_id'] ) : 0;

		if ( ! $post_id ) {
			wp_send_json_error( esc_html__( 'Invalid article ID.', 'voidek-serp-schema-builder' ) );
		}

		$schema = Vserpb_Article_Schema::vserpb_generate_schema( $post_id );

		wp_send_json_success( $schema );
	}


}

// Initialize the AJAX handler
VSERPB_Ajax_Handler::init();
