<?php
 if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Vserpb_TranslatorSpecification {

	private $post_id;

	/**
	 * __construct
	 *
	 * @param  mixed $post_id
	 * @return void
	 */
	public function __construct( $post_id ) {
		$this->post_id = $post_id;
	}

	/**
	 * Vserpb_getSchema
	 *
	 * @return void
	 */
	public function vserpb_getSchema() {
		$type = get_post_meta( $this->post_id, 'translator_type', true ); // Person or Organization
		$name = get_post_meta( $this->post_id, 'translator_name', true );
		$url  = get_post_meta( $this->post_id, 'translator_url', true );

		if ( empty( $type ) || empty( $name ) ) {
			return null; // Invalid schema if name or type is missing
		}

		$schema = array(
			'@type' => $type,
			'name'  => $name,
		);

		if ( ! empty( $url ) ) {
			$schema['url'] = $url;
		}

		return $schema;
	}
}
