<?php
 if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Vserpb_ThumbnailSpecification {

	private $post_id;
	
	/**
	 * __construct
	 *
	 * @param  mixed $post_id
	 * @return void
	 */
	public function __construct( $post_id ) {
		$this->post_id = $post_id;
	}
	
	/**
	 * vserpb_getSchema
	 *
	 * @return void
	 */
	public function vserpb_getSchema() {
		if ( ! has_post_thumbnail( $this->post_id ) ) {
			return null;
		}

		$thumbnail_id = get_post_thumbnail_id( $this->post_id );
		$image_url    = wp_get_attachment_url( $thumbnail_id );
		$meta         = wp_get_attachment_metadata( $thumbnail_id );

		$width  = isset( $meta['width'] ) ? $meta['width'] : null;
		$height = isset( $meta['height'] ) ? $meta['height'] : null;

		return array(
			'@type'  => 'ImageObject',
			'url'    => $image_url,
			'width'  => $width,
			'height' => $height,
		);
	}
}
