<?php
 if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Vserpb_Thing {

	// Product Properties
	private $product_id;
	private $alternateName;

	// Common Properties
	private $name;
	private $description;
	private $identifier;
	private $url;

	// Article Properties
	private $additionaltype;


	/**
	 * Thing constructor.
	 *
	 * @param int    $id The WordPress post ID
	 * @param string $post_type The post type (e.g., Product, Article)
	 */
	public function __construct( $id, $post_type ) {
		if ( $post_type === 'Product' ) {
			$this->product_id = $id;

			// Set Product-specific properties
			$this->name          = get_the_title( $id );
			$this->description   = get_post_field( 'post_content', $id );
			$this->identifier    = get_post_meta( $id, '_sku', true );
			$this->alternateName = $this->name;
			$this->url           = get_permalink( $id );
		}

		if ( $post_type === 'Article' ) {
			$this->name           = get_the_title( $id );
			$this->description    = get_the_excerpt( $id );
			$this->url            = get_permalink( $id );
			$this->alternateName = $this->name;
			$this->identifier     = (string) $id;
			$this->additionaltype = get_post_type( $id );
		}

		
	}

	/**
	 * Generate and return the schema for a Thing.
	 *
	 * @param string $post_type
	 * @return array
	 */
	public function vserpb_getSchema( $post_type ) {
		if ( $post_type === 'Product' ) {
			return array(
				'@type'         => 'Thing',
				'name'          => $this->name,
				'description'   => $this->description,
				'identifier'    => $this->identifier,
				'alternateName' => $this->alternateName,
				'url'           => $this->url,
			);
		}

		if ( $post_type === 'Article' ) {
			return array(
				'@type'          => 'Thing',
				'name'           => $this->name,
				'description'    => $this->description,
				'url'            => $this->url,
				'identifier'     => $this->identifier,
			'alternateName' => $this->alternateName,
				'additionalType' => $this->additionaltype,
			);
		}

	
	}
}
