<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Vserpb_Size {

    private $product;

    public function __construct( $product_id ) {
        $this->product = wc_get_product( $product_id );
    }

    public function vserpb_getSchema() {
        $schema = array();
        $attributes = array();

        foreach ( $this->product->get_attributes() as $attribute_name => $attribute ) {
            $attributes[ $attribute_name ] = $this->product->get_attribute( $attribute_name );
        }

        $schema['size'] = array();

        if ( ! empty( $attributes ) ) {
            foreach ( $attributes as $key => $value ) {
                if ( strpos( strtolower( $key ), 'size' ) !== false ) {
                    $schema['size'][] = $value; // returns size string like S,M,L,XL
                }
            }
        }

        return $schema['size'];
    }
}
