<?php
 if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Vserpb_PublicationSpecification {

	private $post_id;
	private $data;
	
	/**
	 * __construct
	 *
	 * @param  mixed $post_id
	 * @return void
	 */
	public function __construct( $post_id ) {
		$this->post_id = $post_id;

		$this->data = array(
			'startDate'   => get_the_date( 'c', $post_id ),
			'publishedOn' => get_bloginfo( 'name' ),
			'publishedBy' => $this->vserpb_getAuthorName(),
		);
	}
	
	/**
	 * vserpb_getAuthorName
	 *
	 * @return void
	 */
	private function vserpb_getAuthorName() {
		$author_id = get_post_field( 'post_author', $this->post_id );
		return get_the_author_meta( 'display_name', $author_id );
	}
	
	/**
	 * vserpb_getSchema
	 *
	 * @return void
	 */
	public function vserpb_getSchema() {
		$filtered = array_filter(
			$this->data,
			function ( $value ) {
				return ! empty( $value );
			}
		);

		return ! empty( $filtered ) ? $filtered : null;
	}
}
