<?php
 if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Vserpb_PropertyValue {

	private $product_id;
	private $rating_id;
	private $product_name;
	private $product_url;
	
	/**
	 * __construct
	 *
	 * @param  mixed $product_id
	 * @return void
	 */
	public function __construct( $product_id ) {
		$this->product_id = $product_id;

		$product = wc_get_product( $product_id );

		if ( ! $product ) {
			throw new Exception( 'Invalid product ID: ' . esc_html( $product_id ) );
		}

		$this->product_name = $product->get_name();
		$this->product_url  = get_permalink( $this->product_id );
		$this->rating_id    = 'RATING-' . $this->product_id;
	}
	
	/**
	 * vserpb_getSchema
	 *
	 * @return void
	 */
	public function vserpb_getSchema() {
		return array(
			'@type'       => 'PropertyValue',
			'name'        => 'Rating ID',
			'value'       => $this->rating_id,
			'description' => "A unique identifier for the rating of {$this->product_name}",
			'url'         => "{$this->product_url}/rating",
		);
	}	
	/**
	 * vserpb_getSchemaByProperties
	 *
	 * @param  mixed $properties
	 * @return void
	 */
	public function vserpb_getSchemaByProperties( ...$properties ) {
		$schema = array(
			'@type' => 'PropertyValue',
		);

		foreach ( $properties as $property ) {
			if ( ! is_string( $property ) ) {
				continue;
			}

			switch ( $property ) {
				case 'name':
					$schema['name'] = 'Rating ID';
					break;
				case 'value':
					$schema['value'] = $this->rating_id ?? null;
					break;
				case 'description':
					$schema['description'] = "A unique identifier for the rating of {$this->product_name}";
					break;
				case 'url':
					$schema['url'] = "{$this->product_url}/rating";
					break;
			}
		}

		return $schema;
	}
}
