<?php
 if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Vserpb_PostalAddress {

	private $location_name;
	private $street_address;
	private $address_locality;
	private $address_region;
	private $postal_code;
	private $address_country;
	
	/**
	 * __construct
	 *
	 * @param  mixed $post_id
	 * @return void
	 */
	public function __construct( $post_id ) {
		$this->street_address   = get_post_meta( $post_id, '_street_address', true );
		$this->address_locality = get_post_meta( $post_id, '_address_locality', true );
		$this->address_region   = get_post_meta( $post_id, '_address_region', true );
		$this->postal_code      = get_post_meta( $post_id, '_postal_code', true );
		$this->address_country  = get_post_meta( $post_id, '_address_country', true );
	}
	
	/**
	 * vserpb_getSchema
	 *
	 * @return void
	 */
	public function vserpb_getSchema() {
		if (empty($this->location_name) || empty($this->address_locality))
		{
		return null;
		}

		return array(
			'@type'           => 'PostalAddress',
			'streetAddress'   => $this->street_address,
			'addressLocality' => $this->address_locality,
			'addressRegion'   => $this->address_region,
			'postalCode'      => $this->postal_code,
			'addressCountry'  => $this->address_country,
		);
	}
}
