<?php
 if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

require_once VSERPB_PLUGIN_DIR . '/Schema_classes/class-vserpb-postaladdress.php';
class Vserpb_Place {

	private $location_name;
	private $post_id;
	
	/**
	 * __construct
	 *
	 * @param  mixed $post_id
	 * @return void
	 */
	public function __construct( $post_id ) {
		$this->post_id       = $post_id;
		$this->location_name = get_post_meta( $post_id, '_location_name', true );
	}
	
	/**
	 * vserpb_getSchema
	 *
	 * @return void
	 */
	public function vserpb_getSchema() {
		if (empty($this->location_name))
		{
		return null;
		}
		return array(
			'@type'   => 'Place',
			'name'    => $this->location_name,
			'address' => ( new Vserpb_PostalAddress( $this->post_id ) )->vserpb_getSchema(),
		);
	}
}
