<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Vserpb_Person {

	public $name;
	public $url;

	/**
	 * __construct
	 *
	 * @param string      $name
	 * @param string|null $url
	 */
	public function __construct( $name, $url = null ) {
		$this->name = sanitize_text_field( $name );
		$this->url  = $url ? esc_url_raw( $url ) : null;
	}

	/**
	 * vserpb_getSchema
	 *
	 * @return array
	 */
	public function vserpb_getSchema() {

		$schema = array(
			'@type' => 'Person',
			'name'  => $this->name,
		);

		// Add URL only if provided
		if ( ! empty( $this->url ) ) {
			$schema['url'] = $this->url;
		}

		return $schema;
	}
}
