<?php
 if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
class Vserpb_Organization {
    public $name;
    public $url;
    public $description;
    public $logo;
    public function __construct( $args = array() ) {
       
        $this->name = ! empty( $args['name'] ) ? $args['name'] : get_bloginfo( 'name' );
        $this->url  = ! empty( $args['url'] )  ? $args['url']  : home_url();
        $this->description = $args['description'] ?? '';
        $this->logo        = $args['logo'] ?? '';
    }

    public function vserpb_getSchema() {
        $schema = array(
            '@type' => 'Organization',
            'name'  => wp_strip_all_tags( $this->name ),
            'url'   => esc_url_raw( $this->url ),
        );

        if ( ! empty( $this->description ) ) {
            $schema['description'] = wp_strip_all_tags( $this->description );
        }

        if ( ! empty( $this->logo ) ) {
            $schema['logo'] = esc_url_raw( $this->logo );
        }

        return $schema;
        
    }
}
