<?php
 if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Vserpb_Keyword {

	private $post_id;
	private $taxonomy;
	private $tags = array();
	
	/**
	 * __construct
	 *
	 * @param  mixed $post_id
	 * @param  mixed $taxonomy
	 * @return void
	 */
	public function __construct( $post_id, $taxonomy = 'post_tag' ) {
		// default to 'post_tag' for articles
		$this->post_id  = $post_id;
		$this->taxonomy = $taxonomy;

		$terms = wp_get_post_terms( $this->post_id, $this->taxonomy );

		if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
			foreach ( $terms as $term ) {
				$this->tags[] = array(
					'@type'       => 'DefinedTerm',
					'name'        => $term->name,
					'description' => $term->description ?? '',
					'identifier'  => $term->term_id,
					'url'         => get_term_link( $term ),
					'termCode'    => $term->term_id,
				);
			}
		}
	}

	/**
	 * vserpb_getSchema
	 *
	 * @return void
	 */
	public function vserpb_getSchema() {
		return $this->tags;
	}
}
