<?php
 if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Vserpb_InLanguageSpecification {

	private $post_id;
	private $data;
	
	/**
	 * __construct
	 *
	 * @param  mixed $post_id
	 * @return void
	 */
	public function __construct( $post_id ) {
		$this->post_id = $post_id;

		$this->data = array(
			'alternateName' => get_post_meta( $post_id, 'inLanguage_alternateName', true ),
			'description'   => get_post_meta( $post_id, 'inLanguage_description', true ),
			'identifier'    => get_post_meta( $post_id, 'inLanguage_identifier', true ),
			'name'          => get_post_meta( $post_id, 'inLanguage_name', true ),
			'sameAs'        => get_post_meta( $post_id, 'inLanguage_sameAs', true ),
			'url'           => get_post_meta( $post_id, 'inLanguage_url', true ),
		);
	}

	/**
	 * vserpb_getSchema
	 *
	 * @return void
	 */
	public function vserpb_getSchema() {
		// Filter out empty fields
		$filtered = array_filter( $this->data );

		return ! empty( $filtered ) ? $filtered : null;
	}
}
