<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Vserpb_ImageObject {

    private $image_url;
    private $image_name;
    private $image_width;
    private $image_height;

    /**
     * __construct
     *
     * @param  int $product_id
     */
    public function __construct( $product_id ) {

        // Get product image ID (featured image)
        $image_id = get_post_thumbnail_id( $product_id );

        if ( $image_id ) {
            $this->image_mime = get_post_mime_type( $image_id );
            $this->image_url   = wp_get_attachment_url( $image_id );
            $this->image_name  = get_the_title( $image_id );
            $image_metadata    = wp_get_attachment_metadata( $image_id );

            if ( isset( $image_metadata['width'] ) ) {
                $this->image_width  = $image_metadata['width'];
            }

            if ( isset( $image_metadata['height'] ) ) {
                $this->image_height = $image_metadata['height'];
            }
        }
    }

    /**
     * vserpb_getSchema
     *
     * @return array
     */
    public function vserpb_getSchema() {

        if ( empty( $this->image_url ) ) {
            return []; // No image found
        }

        return array(
            '@type'  => 'ImageObject',
            'url'    => $this->image_url,
            'name'   => $this->image_name,
            'width'  => $this->image_width,
            'height' => $this->image_height,
             'encodingFormat' => $this->image_mime,
        );
    }
}
