<?php
 if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Vserpb_Country {

	private $name;


	public function __construct( $product_id ) {
		if ( empty( $country_name ) ) {

			$store_setting = get_option( 'woocommerce_default_country' );

			$parts = explode( ':', $store_setting );
			$country_code = $parts[0];  // e.g., "IN"

			$all = WC()->countries->get_countries();

			$country_name = isset( $all[ $country_code ] )
				? $all[ $country_code ]
				: $country_code;
		}

		$this->name = $country_name;	
	}

	/**
	 * vserpb_getSchema
	 *
	 * @return void
	 */
	public function vserpb_getSchema() {
	
		return array(
			'@type' => 'Country',
			'name'  => $this->name,
		);
	}
}
