<?php

 if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Vserpb_Comment
 */
class Vserpb_Comment {

	private $comment_id;
	private $content;
	private $author_name;
	private $date_published;
	private $upvote_count;
	private $downvote_count;
	
	/**
	 * __construct
	 *
	 * @param  mixed $comment
	 * @return void
	 */
	public function __construct( $comment ) {
		$this->comment_id     = $comment->comment_ID;
		$this->content        = wp_strip_all_tags( $comment->comment_content );
		$this->author_name    = get_comment_author( $this->comment_id );
		$this->date_published = get_comment_date( 'c', $this->comment_id );
		$this->upvote_count   = get_comment_meta( $this->comment_id, 'upvoteCount', true ) ?: 0;
		$this->downvote_count = get_comment_meta( $this->comment_id, 'downvoteCount', true ) ?: 0;
	}

	/**
	 * vserpb_getSchema
	 *
	 * @return void
	 */
	public function vserpb_getSchema() {
		return array(
			'@type'         => 'Comment',
			'text'          => $this->content,
			'author'        => array(
				'@type' => 'Person',
				'name'  => $this->author_name,
			),
			'datePublished' => $this->date_published,
			'upvoteCount'   => (int) $this->upvote_count,
			'downvoteCount' => (int) $this->downvote_count,
		);
	}
}
