<?php
 if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Vserpb_Color {

	private $product;
	
	/**
	 * __construct
	 *
	 * @param  mixed $product_id
	 * @return void
	 */
	public function __construct( $product_id ) {
		$this->product = wc_get_product( $product_id );
	}

	/**
	 * vserpb_get_schema
	 *
	 * @return void
	 */
	public function vserpb_get_schema() {
		$schema = array();

			$attributes = array();

		foreach ( $this->product->get_attributes() as $attribute_name => $attribute ) {
			$attributes[ $attribute_name ] = $this->product->get_attribute( $attribute_name );
		}
			$schema['color'] = array();
		if ( ! empty( $attributes ) ) {
			foreach ( $attributes as $key => $value ) {
				if ( strpos( strtolower( $key ), 'color' ) !== false ) {
					$schema['color'][] = array(
						$value,
					);
				}
			}
		}

		return $schema['color'];
	}
}
