<?php
if (!defined('ABSPATH'))
{
    exit;
} ?>
<div class="wrap vso-backend-setting-wrap" id="backend-seetting-wrap">
    <h1><?php esc_html_e('Voice Search Settings', 'voice-search-optimization'); ?></h1>
    <!-- TABS NAVIGATION -->
    <h2 class="nav-tab-wrapper">
        <a href="#" id="tab-general-settings" class="nav-tab nav-tab-active"><?php esc_html_e('General Settings', 'voice-search-optimization'); ?></a>
        <a href="#" id="tab-shortcode-info" class="nav-tab"><?php esc_html_e('Shortcode Info', 'voice-search-optimization'); ?></a>
    </h2>
    <!-- TAB CONTENT -->
    <div id="general-settings-content" class="tab-content">
        <?php settings_errors(); ?>
        <form method="post" action="options.php">
            <?php 
            // ENSURE SETTINGS FIELDS ARE CORRECTLY INCLUDED
            settings_fields('voicseop_plugin_settings'); 
            do_settings_sections('voicseop_plugin_settings'); 

            // RETRIEVE THE CURRENT OPTION VALUES INTO VARIABLES
            $vso_search_bar_show = get_option('voicseop_enable_text_search');
            $vso_voice_search = get_option('voicseop_enable_voice_search');
            $vso_voice_search_timeout = get_option('voicseop_voice_search_timeout', 20);
            $vso_voice_command = get_option('voicseop_enable_voice_command');
            $vso_voice_command_timeout = get_option('voicseop_voice_command_timeout', 20);
            $vso_voicseop_voice_command_position = get_option('voicseop_voice_command_position'); ?>
            <table class="form-table">
                <tr>
                    <th scope="row"><label for="voicseop_enable_text_search"><?php esc_html_e('Enable Text Search', 'voice-search-optimization'); ?></label></th>
                    <td>
                        <label class="vso_switch">
                            <input type="checkbox" name="voicseop_enable_text_search" id="enable_text_search" value="yes" <?php if ($vso_search_bar_show == 'yes') echo esc_html__('checked=checked', 'voice-search-optimization'); ?>>
                            <span class="vso_slider round"></span>
                        </label>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><label for="voicseop_enable_voice_search"><?php esc_html_e('Enable Voice Search', 'voice-search-optimization'); ?></label></th>
                    <td>
                        <label class="vso_switch">
                            <input type="checkbox" name="voicseop_enable_voice_search" id="enable_voice_search" value="yes" <?php if ($vso_voice_search == 'yes') echo esc_html__('checked=checked', 'voice-search-optimization'); ?>>
                            <span class="vso_slider round"></span>
                        </label>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><label for="voicseop_voice_search_timeout"><?php esc_html_e('Voice Search Timeout (seconds)', 'voice-search-optimization'); ?></label></th>
                    <td>
                        <input type="number" name="voicseop_voice_search_timeout" id="voice_search_timeout" value="<?php echo esc_attr($vso_voice_search_timeout); ?>" min="10" max="90" step="1" />
                        <p class="description"><?php esc_html_e('Set the timeout duration for voice search in seconds.', 'voice-search-optimization'); ?></p>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><label for="voicseop_enable_voice_command"><?php esc_html_e('Enable Voice Command', 'voice-search-optimization'); ?></label></th>
                    <td>
                        <label class="vso_switch">
                            <input type="checkbox" name="voicseop_enable_voice_command" id="enable_voice_command" value="yes" <?php if ($vso_voice_command == 'yes') echo esc_html__('checked=checked', 'voice-search-optimization'); ?>>
                            <span class="vso_slider round"></span>
                        </label>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><label for="voicseop_voice_command_timeout"><?php esc_html_e('Voice Command Timeout (seconds)', 'voice-search-optimization'); ?></label></th>
                    <td>
                        <input type="number" name="voicseop_voice_command_timeout" id="voice_command_timeout" value="<?php echo esc_attr($vso_voice_command_timeout); ?>" min="10" max="90" step="1" />
                        <p class="description"><?php esc_html_e('Set the timeout duration for voice command in seconds.', 'voice-search-optimization'); ?></p>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><label for="voicseop_voice_command_position"><?php esc_html_e('Voice Command Icon Position', 'voice-search-optimization'); ?></label></th>
                    <td>
                        <fieldset class="vso-command-radio">
                            <label>
                                <input type="radio" name="voicseop_voice_command_position" value="bottom-left" 
                                    <?php if ($vso_voicseop_voice_command_position === 'bottom-left') echo esc_html__('checked=checked', 'voice-search-optimization'); ?> />
                                <?php esc_html_e('Bottom Left', 'voice-search-optimization'); ?>
                            </label>
                            <label>
                                <input type="radio" name="voicseop_voice_command_position" value="bottom-right" 
                                    <?php if ($vso_voicseop_voice_command_position === 'bottom-right') echo esc_html__('checked=checked', 'voice-search-optimization'); ?> />
                                <?php esc_html_e('Bottom Right', 'voice-search-optimization'); ?>
                            </label>
                        </fieldset>
                        <p class="description"><?php esc_html_e('Select the position of the voice command icon on the screen.', 'voice-search-optimization'); ?></p>
                    </td>
                </tr>
            </table>
            <?php submit_button(); ?>
        </form>
    </div>
    <div id="shortcode-info-content" class="tab-content" style="display: none;">
        <h2><?php esc_html_e('Shortcode Information', 'voice-search-optimization'); ?></h2>
        <div class="short-info-row"> 
            <div class="short-infor-inner-row">
                <div class="voice-search-title-box">
                    <label><?php esc_html_e('Voice Search Shortcode', 'voice-search-optimization'); ?></label>
                </div>
                <div class="short-col">
                    <input type="text" value="[voice_search]" id="voice_search_shortcode" readonly />
                    <div id="voice_search_copied_message" class="copied-message" style="display: none;"><?php esc_html_e('Copied!', 'voice-search-optimization'); ?></div>
                </div>
            </div>
            <div class="voice-search-detail">
                <p><strong><?php esc_html_e('Note:', 'voice-search-optimization'); ?></strong> <?php esc_html_e('Use this shortcode in your posts or pages to display a search form with both text and voice search, based on your settings.', 'voice-search-optimization'); ?></p>
            </div>
        </div>
        <div class="short-info-row">
            <div class="short-infor-inner-row">
                <div class="voice-search-title-box">
                    <label><?php esc_html_e('Voice Command Shortcode', 'voice-search-optimization'); ?></label>
                </div>
                <div class="short-col">
                    <input type="text" value="[voice_command]" id="voice_command_shortcode" readonly />
                    <div id="voice_command_copied_message" class="copied-message" style="display: none;"><?php esc_html_e('Copied!', 'voice-search-optimization'); ?></div>
                </div>
            </div>
            <div class="voice-search-detail">
                <p><strong><?php esc_html_e('Note:', 'voice-search-optimization'); ?></strong> <?php esc_html_e('This shortcode will display a voice command button and allow users to navigate to any page, post, product, or other content type by saying Go to [post title].', 'voice-search-optimization'); ?></p>
            </div>
        </div>
    </div>
</div>