// START - VOICE SEARCH AND TEXT SEARCH IN '[voice_search]'
jQuery(document).ready(function ($) {
    const searchInput = $('.vso-search-input');
    const searchButton = $('.vso-search-button');
    const voiceSearchButton = $('.vso-voice-search-button');
    const clearButton = $('.vso-clear-button');
    const resultsContainer = $('#vso-search-results');
    const voiceCommandButton = $('#vso-voice-command-button');

    setTimeout(function () {
        // CHECK IF THE #fpwap_smallBanner DIV IS PRESENT
        if ($('div#ifpwap_smallBanner').length === 0) {
            $('.vso-voice-command-button-sec').addClass('vso-cmnd-btn-footer');
        }
    }, 2000);

    // CHECK IF BROWSER SUPPORTS SpeechRecognition API
    const isVoiceSearchSupported = 'SpeechRecognition' in window || 'webkitSpeechRecognition' in window;

    if (!isVoiceSearchSupported) {
        voiceSearchButton.hide();
        voiceCommandButton.hide();
        resultsContainer.html('<p>Your browser does not support voice search. You can still use text search.</p>');
    }

    const recognition = isVoiceSearchSupported ? new (window.SpeechRecognition || window.webkitSpeechRecognition)() : null;
    if (recognition) {
        recognition.lang = 'en-US';
        recognition.interimResults = true;
        recognition.continuous = false;
    }

    // USE THE TIMEOUT VALUE FROM BACKEND SETTINGS
    const voiceSearchTimeout = voicseop_ajax.voicseop_voice_search_timeout * 1000; // Convert to milliseconds

    // HANDLE VOICE SEARCH BUTTON CLICK
    // HANDLE VOICE SEARCH BUTTON CLICK
    voiceSearchButton.on('click', function (e) {
        e.preventDefault(); // Prevent the form submission

        if (!searchInput.length) {
            resultsContainer.html('<p>Voice search input is unavailable. Please enable text search or contact the administrator.</p>');
            return;
        }

        // Start the voice recognition process
        recognition.start();

        resultsContainer.html('<p>Listening...</p>');
        $("#update").prop("disabled", true);

        // Set a timeout to stop recognition after the configured duration
        setTimeout(function () {
            recognition.stop();
        }, voiceSearchTimeout);
    });


    recognition.onresult = function (event) {
        let transcript = '';
        for (let i = 0; i < event.results.length; i++) {
            transcript += event.results[i][0].transcript;
        }

        if (searchInput.length) {
            searchInput.val(transcript);
        }

        performSearch(transcript);
    };

    recognition.onspeechend = function () {
        recognition.stop();

        // ENSURE SEARCHINPUT IS A VALID ELEMENT AND HAS A VALUE
        const query = searchInput.val() ? searchInput.val().trim() : '';

        if (query) {
            performSearch(query);
        } else {
            resultsContainer.html('<p>Please enter a search term.</p>');
        }
    };

    recognition.onerror = function (event) {
        let errorMsg = 'An error occurred during voice recognition.';
        if (event.error === 'not-allowed') {
            errorMsg = 'Microphone access is denied. Please enable it in your browser settings.';
        }
        resultsContainer.html('<p>' + errorMsg + '</p>');
    };

    // HANDLE SEARCH BUTTON CLICK
    searchButton.on('click', function () {
        const query = searchInput.val().trim();
        if (query) {
            performSearch(query);
        } else {
            resultsContainer.html('<p>Please enter a search term.</p>');
        }
    });

    // HANDLE ENTER KEY PRESS FOR SEARCHING
    searchInput.on('keypress', function (e) {
        if (e.which === 13) {
            e.preventDefault();
            const query = searchInput.val().trim();
            if (query) {
                performSearch(query);
            } else {
                resultsContainer.html('<p>Please enter a search term.</p>');
            }
        }
    });

    function performSearch(query) {
        if (!query.trim()) {
            resultsContainer.html('<p>No search query provided.</p>');
            return;
        }

        const nonce = voicseop_ajax.nonce;  // Retrieve the nonce value
        const searchUrl = voicseop_ajax.home_url + '/?s=' + encodeURIComponent(query) + '&voicseop_nonce_field=' + nonce;

        window.location.href = searchUrl;
    }

    // HANDLE THE "CLEAR" BUTTON FUNCTIONALITY
    clearButton.on('click', function (e) {
        e.preventDefault();
        searchInput.val('');
        resultsContainer.empty();
    });
});
// END - VOICE SEARCH AND TEXT SEARCH IN '[voice_search]'
// START - VOICE COMMAND SEARCH AND REDIRECTING RESPECTIVE RESULT IN '[voice_command]'
jQuery(document).ready(function ($) {

    const voiceCommandButton = $('#vso-voice-command-button');

    // CHECK IF SpeechRecognition IS SUPPORTED
    if (!('SpeechRecognition' in window || 'webkitSpeechRecognition' in window)) {
        alert('Speech recognition is not supported in this browser.');
        return;
    }

    // INITIALIZE voicseop_voice_command_timeout FROM LOCALIZED SETTINGS (CONVERT TO MILLISECONDS)
    const voiceRecognitionTimeout = voicseop_ajax.voicseop_voice_command_timeout * 1000;

    console.log('Voice command timeout:', voiceRecognitionTimeout);

    const recognition = new (window.SpeechRecognition || window.webkitSpeechRecognition)();
    recognition.lang = 'en-US';
    recognition.interimResults = false;

    let isRecognizing = false;
    let recognitionTimeout;

    // VOICE COMMAND BUTTON CLICK HANDLER
    $('#vso-voice-command-button').on('click', function () {
        if (isRecognizing) {
            // ALERT IF BUTTON IS CLICKED MULTIPLE TIMES
            // $(".vso-voice-search-button").prop("disabled",false);
            alert('Please do not press the button multiple times');
            return;
        }

        try {
            recognition.start();
            isRecognizing = true;
            $('#vso-command-status').text('Listening... Speak now.');
            $(".vso-voice-search-button").prop("disabled",true);

            // SET TIMEOUT TO STOP RECOGNITION
            recognitionTimeout = setTimeout(() => {
                recognition.stop();
                $('#vso-command-status').text('Timeout: Speech recognition stopped.');
            }, voiceRecognitionTimeout + 2000);
        } catch (error) {
            console.error('Recognition Start Error:', error);
            // $(".vso-voice-search-button").prop("disabled",false);
            alert('Error starting speech recognition: ' + error.message);
        }
    });

    recognition.onresult = function (event) {
        clearTimeout(recognitionTimeout);
        isRecognizing = false;

        const transcript = event.results[0][0].transcript.toLowerCase();
        // $('#vso-command-status').text(`You said: "${transcript}"`);
        handleVoiceCommand(transcript);
    };

    recognition.onerror = function (event) {
        clearTimeout(recognitionTimeout);
        isRecognizing = false;

        console.error('Speech Recognition Error:', event.error);
        let errorMessage = 'An error occurred during speech recognition.';

        switch (event.error) {
            case 'network':
                errorMessage = 'Network error: Please check your internet connection.';
                break;
            case 'not-allowed':
                errorMessage = 'Permission denied: Please allow microphone access.';
                break;
            case 'no-speech':
                errorMessage = 'No speech detected: Please speak into the microphone.';
                break;
            case 'audio-capture':
                errorMessage = 'Microphone error: Please ensure your microphone is working.';
                break;
            default:
                errorMessage = `Error: ${event.error}`;
        }

        $('#vso-command-status').text(errorMessage);
        alert(errorMessage);
    };

    // HANDLE THE VOICE COMMAND (e.g., "Go to [post title]")
    function handleVoiceCommand(command) {

        if (command.startsWith('go to')) {
            const postName = command.replace('go to', '').trim();

            if (postName) {
                searchPostByName(postName);
            } else {
                alert('Please specify a valid post or page name.');
            }
        } else {
            alert('Command not recognized. Please say "Go to [post title]".');
        }
    }

    function searchPostByName(postName) {
        $('#vso-command-status').text('Searching... Please wait.');
        $.post(voicseop_ajax.ajax_url, {
            action: 'voicseop_search_post',
            post_name: postName,
            nonce_voice_cm: voicseop_ajax.nonce_voice_cm // Include nonce here
        }, function (response) {
            if (response.success) {
                $('#vso-command-status').text(`Redirecting to: ${postName}`);
                window.location.href = response.data.url;
            } else {
                // $(".vso-voice-search-button").prop("disabled",false);
                alert(`Post not found for query: "${postName}"`);
                $('#vso-command-status').text(`Press button & Speak: "Go to [post title]"`);
            }
        }).fail(function (jqXHR, textStatus, errorThrown) {
            console.error('Ajax Error:', textStatus, errorThrown);
            // $(".vso-voice-search-button").prop("disabled",false);
            alert('An error occurred while searching for the post.');
        });
    }
});
// END - VOICE COMMAND SEARCH AND REDIRECTING RESPECTIVE RESULT IN '[voice_command]'