<?php
/********************************************************************
 * Copyright (C) 2024 Darko Gjorgjijoski (https://darkog.com/)
 * Copyright (C) 2024 IDEOLOGIX MEDIA Dooel (https://ideologix.com/)
 *
 * This file is property of IDEOLOGIX MEDIA Dooel (https://ideologix.com)
 * This file is part of Vimeify Plugin - https://wordpress.org/plugins/vimeify/
 *
 * Vimeify - Formerly "WP Vimeo Videos" is free software: you can redistribute
 * it and/or modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the License,
 * or (at your option) any later version.
 *
 * Vimeify - Formerly "WP Vimeo Videos" is distributed in the hope that it
 * will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this plugin. If not, see <https://www.gnu.org/licenses/>.
 *
 * Code developed by Darko Gjorgjijoski <dg@darkog.com>.
 **********************************************************************/

defined( 'ABSPATH' ) || exit;
/* @var \Vimeify\Core\Abstracts\BaseTool $tool */
/* @var \Vimeify\Core\Abstracts\BaseMigrator[] $plugins */
?>
<h2><?php esc_html_e( 'Database Migration', 'vimeify' ); ?></h2>
<div class="vimeify-tool-content">
    <?php if ( count( $plugins ) === 0 ): ?>
        <p><?php esc_html_e( 'No plugins found', 'vimeify' ); ?></p>
    <?php elseif ( count( $plugins ) > 1 ): ?>
        <p><?php esc_html_e( 'This is one-click migration tool that makes it possible to migrate from other plugins easily.', 'vimeify' ); ?></p>
    <?php else: ?>
        <p><?php echo wp_kses( sprintf( __( 'This is one-click migration tool that makes it possible to migrate from %s.', 'vimeify' ), '<strong>' . $plugins[0]->get_name() . '</strong>' ), wp_kses_allowed_html( 'vimeify' ) ); ?></p>
    <?php endif; ?>

    <?php if ( count( $plugins ) > 0 ): ?>
        <form class="vimeify-tool-form vimeify-tool-form--database-migration" method="POST" action="">
            <?php if ( count( $plugins ) > 1 ): ?>
                <div class="vimeify-tool-form-row">
                    <label for="identifier"><?php esc_html_e( 'Select plugin', 'vimeify' ); ?></label>
                    <select id="identifier" name="identifier">
                        <option value="none">---</option>
                        <?php foreach ( $plugins as $plugin ): ?>
                            <option value="<?php echo esc_attr( $plugin->get_id() ); ?>"><?php echo esc_attr( $plugin->get_name() ); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
            <?php else: ?>
                <input type="hidden" id="identifier" name="identifier" value="<?php echo esc_attr( $plugins[0]->get_id() ); ?>"/>
            <?php endif; ?>
            <div class="vimeify-tool-form-row">
                <label>
                    <input type="checkbox" name="consent" class="vimeify-tool-consent" value="1">
                    <span><?php esc_html_e( 'I confirm that i created a backup of my database in case something goes wrong.', 'vimeify' ); ?></span>
                </label>
            </div>
            <div class="vimeify-tool-form-row vimeify-tool-form-row-progress" style="display: none;">
                <div class="vimeify-tool-progress-bar">
                    <p class="vimeify-tool-progress-bar-inner">&nbsp;</p>
                </div>
                <div class="vimeify-tool-progress-info"><?php esc_html_e( 'Initializing...', 'vimeify' ); ?></div>
            </div>
            <div class="vimeify-tool-form-row">
                <input type="hidden" name="id" value="<?php echo esc_attr( $tool->get_id() ); ?>">
                <input type="hidden" name="tool" value="<?php echo esc_attr( $tool->get_slug() ); ?>">
                <button type="submit" class="button button-primary" disabled><?php esc_html_e( 'Migrate', 'vimeify' ); ?></button>
            </div>
            <div class="vimeify-tool-form-row vimeify-tool-form-status" style="display:none;"></div>
        </form>
    <?php endif; ?>
</div>
