<?php
/********************************************************************
 * Copyright (C) 2024 Darko Gjorgjijoski (https://darkog.com/)
 * Copyright (C) 2024 IDEOLOGIX MEDIA Dooel (https://ideologix.com/)
 *
 * This file is property of IDEOLOGIX MEDIA Dooel (https://ideologix.com)
 * This file is part of Vimeify Plugin - https://wordpress.org/plugins/vimeify/
 *
 * Vimeify - Formerly "WP Vimeo Videos" is free software: you can redistribute
 * it and/or modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the License,
 * or (at your option) any later version.
 *
 * Vimeify - Formerly "WP Vimeo Videos" is distributed in the hope that it
 * will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this plugin. If not, see <https://www.gnu.org/licenses/>.
 *
 * Code developed by Darko Gjorgjijoski <dg@darkog.com>.
 **********************************************************************/

use Vimeify\Core\Abstracts\BaseTool;

defined( 'ABSPATH' ) || exit;
/* @var \Vimeify\Core\Plugin|\Vimeify\Core\Abstracts\Interfaces\PluginInterface $plugin */

$tools = $plugin->system()->tools();

?>
<?php include __DIR__ . '/header-bar.php'; ?>
<div class="wrap vimeify-wrap--with-header">

    <h1><?php esc_html_e('Tools', 'vimeify'); ?></h1>

	<?php
	foreach ( $tools as $tool ) {
		/* @var BaseTool $tool_id */
		if ( $tool->is_one_time() && $tool->is_complete() ) {
			return;
		}
		?>
        <div class="vimeify-tool">
			<?php echo $tool->get_view(); ?>
        </div>
		<?php
	} ?>
</div>



