<?php
/********************************************************************
 * Copyright (C) 2024 Darko Gjorgjijoski (https://darkog.com/)
 * Copyright (C) 2024 IDEOLOGIX MEDIA Dooel (https://ideologix.com/)
 *
 * This file is property of IDEOLOGIX MEDIA Dooel (https://ideologix.com)
 * This file is part of Vimeify Plugin - https://wordpress.org/plugins/vimeify/
 *
 * Vimeify - Formerly "WP Vimeo Videos" is free software: you can redistribute
 * it and/or modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the License,
 * or (at your option) any later version.
 *
 * Vimeify - Formerly "WP Vimeo Videos" is distributed in the hope that it
 * will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this plugin. If not, see <https://www.gnu.org/licenses/>.
 *
 * Code developed by Darko Gjorgjijoski <dg@darkog.com>.
 **********************************************************************/

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

?>

<tr>
	<td colspan="2" style="padding: 12px 15px; background: #f0f6fc; border-left: 4px solid #2271b1;">
		<strong><?php esc_html_e( 'Note:', 'vimeify' ); ?></strong>
		<?php esc_html_e( 'These PHP settings are shown for reference. Video uploads use chunked transfers, so PHP upload size limits do not restrict total file size. Memory Limit affects how much data can be processed at once during uploads.', 'vimeify' ); ?>
	</td>
</tr>
<tr>
	<th style="width: 20%">
		<?php esc_html_e( 'PHP Version', 'vimeify' ); ?>
	</th>
	<td>
		<?php echo esc_html( PHP_VERSION ); ?>
	</td>
</tr>
<?php if ( isset( $_SERVER['SERVER_SOFTWARE'] ) ): ?>
	<tr>
		<th>
			<?php esc_html_e( 'Web Server', 'vimeify' ); ?>
		</th>
		<td>
			<?php echo esc_html( sanitize_text_field( wp_unslash( $_SERVER['SERVER_SOFTWARE'] ) ) ); ?>
		</td>
	</tr>
<?php endif; ?>
<tr>
	<th>
		<?php esc_html_e( 'Max Upload Size', 'vimeify' ); ?>
	</th>
	<td>
		<?php echo esc_html( ini_get( 'upload_max_filesize' ) ); ?>
	</td>
</tr>
<tr>
	<th>
		<?php esc_html_e( 'Max Post Size', 'vimeify' ); ?>
	</th>
	<td>
		<?php echo esc_html( ini_get( 'post_max_size' ) ); ?>
	</td>
</tr>
<tr>
	<th>
		<?php esc_html_e( 'Max Exec Time', 'vimeify' ); ?>
	</th>
	<td>
		<?php echo intval( ini_get( 'max_execution_time' ) ); ?>
	</td>
</tr>
<tr>
	<th>
		<?php esc_html_e( 'Max Input Time', 'vimeify' ); ?>
	</th>
	<td>
		<?php echo intval( ini_get( 'max_input_time' ) ); ?>
	</td>
</tr>
<tr>
    <th>
		<?php esc_html_e( 'Memory Limit', 'vimeify' ); ?>
    </th>
    <td>
	    <?php echo sprintf( 'WP %s / PHP %s', esc_html( WP_MEMORY_LIMIT ), esc_html( ini_get( 'memory_limit' ) ) ); ?>
    </td>
</tr>
<tr>
    <th>
		<?php esc_html_e( 'Operating System', 'vimeify' ); ?>
    </th>
    <td>
	    <?php echo esc_html( PHP_OS ); ?>
    </td>
</tr>