<?php
/********************************************************************
 * Copyright (C) 2024 Darko Gjorgjijoski (https://darkog.com/)
 * Copyright (C) 2024 IDEOLOGIX MEDIA Dooel (https://ideologix.com/)
 *
 * This file is property of IDEOLOGIX MEDIA Dooel (https://ideologix.com)
 * This file is part of Vimeify Plugin - https://wordpress.org/plugins/vimeify/
 *
 * Vimeify - Formerly "WP Vimeo Videos" is free software: you can redistribute
 * it and/or modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the License,
 * or (at your option) any later version.
 *
 * Vimeify - Formerly "WP Vimeo Videos" is distributed in the hope that it
 * will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this plugin. If not, see <https://www.gnu.org/licenses/>.
 *
 * Code developed by Darko Gjorgjijoski <dg@darkog.com>.
 **********************************************************************/

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/* @var \Vimeify\Core\Plugin $plugin */

// Urls
$url_guide    = $plugin->documentation_url();
$url_purchase = $plugin->commercial_url();

// Dismiss Init
$dismiss_link = esc_url( add_query_arg( [
	'dismiss'  => 'yes',
	'action'   => 'vimeify_dismiss_instructions',
	'_wpnonce' => wp_create_nonce( 'vimeify_nonce' ),
], admin_url( 'admin-ajax.php' ) ) );

?>
<div class="notice notice-info is-dismissible">

    <h3><?php esc_html_e('Vimeify Migration'); ?></h3>
	<p>
		<?php echo sprintf(__('Looks like you used %s before. It\'s possible to migrate your data to Vimeify, simply navigate to the migration page.', 'vimeify'), '<strong>Video Uploads for Vimeo</strong>'); ?>
	</p>
	<p>
		<a href="<?php echo esc_url( admin_url( 'admin.php?page=vimeify-tools' ) ); ?>" class="button button-primary">
            <?php esc_html_e( 'Migrate Now', 'vimeify' ); ?>
        </a>
	</p>

    <p></p>

    <a href="<?php echo esc_url( $dismiss_link ); ?>" class="notice-dismiss vimeify-notice-dismiss">
        <span class="screen-reader-text"><?php esc_html_e( 'Dismiss this notice', 'vimeify' ); ?>.</span>
    </a>

</div>
