<?php
/********************************************************************
 * Copyright (C) 2024 Darko Gjorgjijoski (https://darkog.com/)
 * Copyright (C) 2024 IDEOLOGIX MEDIA Dooel (https://ideologix.com/)
 *
 * This file is property of IDEOLOGIX MEDIA Dooel (https://ideologix.com)
 * This file is part of Vimeify Plugin - https://wordpress.org/plugins/vimeify/
 *
 * Vimeify - Formerly "WP Vimeo Videos" is free software: you can redistribute
 * it and/or modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the License,
 * or (at your option) any later version.
 *
 * Vimeify - Formerly "WP Vimeo Videos" is distributed in the hope that it
 * will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this plugin. If not, see <https://www.gnu.org/licenses/>.
 *
 * Code developed by Darko Gjorgjijoski <dg@darkog.com>.
 **********************************************************************/

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/* @var \Vimeify\Core\Plugin $plugin */


$default_folder_uri = $plugin->system()->settings()->profile()->get( 'Backend.Form.Upload', 'folder' );
if ( $plugin->system()->vimeo()->state->is_connected && $default_folder_uri ) {
	$default_folder_name = sprintf( '%s (Default)', $plugin->system()->vimeo()->get_folder_name( $default_folder_uri ) );
}


$enable_view_privacy = (int) $plugin->system()->settings()->global()->get( 'admin.upload_forms.enable_view_privacy', 0 );
$enable_folders      = (int) $plugin->system()->settings()->global()->get( 'admin.upload_forms.enable_folders', 0 );


?>
<?php include __DIR__ . '/header-bar.php'; ?>
<div class="wrap vimeify-wrap vimeify-wrap--with-header">

    <h1><?php esc_html_e( 'Upload to Vimeo', 'vimeify' ); ?></h1>

	<?php if ( $plugin->system()->vimeo()->state->is_connected && $plugin->system()->vimeo()->can_upload() ): ?>

        <div class="vimeify-upload-page-container">
            <form class="vimeify-video-upload" enctype="multipart/form-data" method="post" action="/">

                <div class="vimeify-upload-card">
                    <h2><?php esc_html_e( 'Video File', 'vimeify' ); ?></h2>
                    <div class="vimeify-upload-card-content">
                        <div class="vimeify-admin-dropzone-wrapper">
                            <input type="file" name="vimeo_video" id="vimeo_video" class="vimeify-admin-file-input" accept=".mp4,.mov,.flv,.avi,.wmv,video/mp4,video/quicktime,video/x-flv,video/x-msvideo,video/x-ms-wmv">
                            <div class="vimeify-admin-dropzone" id="vimeify-admin-dropzone">
                                <svg class="vimeify-admin-dropzone-icon" width="64" height="64" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"></path>
                                    <polyline points="17 8 12 3 7 8"></polyline>
                                    <line x1="12" y1="3" x2="12" y2="15"></line>
                                </svg>
                                <div class="vimeify-admin-dropzone-text">
                                    <strong><?php esc_html_e( 'Drop your video file here', 'vimeify' ); ?></strong>
                                    <span><?php esc_html_e( 'or click to browse', 'vimeify' ); ?></span>
                                </div>
                            </div>
                            <div class="vimeify-admin-file-preview" id="vimeify-admin-file-preview" style="display: none;">
                                <div class="vimeify-admin-file-info">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                        <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path>
                                        <polyline points="14 2 14 8 20 8"></polyline>
                                        <path d="m9.5 12.5 1.5 2 3-3.5"></path>
                                    </svg>
                                    <span class="vimeify-admin-file-name"></span>
                                </div>
                                <button type="button" class="vimeify-admin-file-remove" title="<?php esc_attr_e( 'Remove file', 'vimeify' ); ?>">
                                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                        <line x1="18" y1="6" x2="6" y2="18"></line>
                                        <line x1="6" y1="6" x2="18" y2="18"></line>
                                    </svg>
                                </button>
                            </div>
                        </div>

                        <div class="vimeify-progress-bar" style="display: none;">
                            <div class="vimeify-progress-bar-inner"></div>
                            <div class="vimeify-progress-bar-value">0%</div>
                        </div>
                    </div>
                </div>

                <div class="vimeify-upload-card">
                    <h2><?php esc_html_e( 'Video Details', 'vimeify' ); ?></h2>
                    <div class="vimeify-upload-card-content">
                        <div class="form-row">
                            <label for="vimeo_title"><?php esc_html_e( 'Title', 'vimeify' ); ?></label>
                            <input type="text" name="vimeo_title" id="vimeo_title" placeholder="<?php esc_attr_e( 'Enter video title', 'vimeify' ); ?>">
                        </div>

                        <div class="form-row">
                            <label for="vimeo_description"><?php esc_html_e( 'Description', 'vimeify' ); ?></label>
                            <textarea name="vimeo_description" id="vimeo_description" rows="4" placeholder="<?php esc_attr_e( 'Enter video description (optional)', 'vimeify' ); ?>"></textarea>
                        </div>

                        <?php if ( $enable_view_privacy ): ?>
                            <?php $view_privacy_opts = $plugin->system()->vimeo()->get_view_privacy_options_for_forms( 'admin' ); ?>
                            <div class="form-row">
                                <label for="vimeo_view_privacy"><?php esc_html_e( 'View Privacy', 'vimeify' ); ?></label>
                                <select name="vimeo_view_privacy" id="vimeo_view_privacy">
                                    <?php foreach ( $view_privacy_opts as $key => $option ): ?>
                                        <?php
                                        $option_state = $option['default'] && $option['available'] ? 'selected' : '';
                                        $option_state .= $option['available'] ? '' : ' disabled';
                                        ?>
                                        <option <?php echo esc_attr( $option_state ); ?> value="<?php echo esc_attr( $key ); ?>"><?php echo esc_html( $option['name'] ); ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        <?php endif; ?>

                        <?php if ( $enable_folders ): ?>
                            <div class="form-row">
                                <label for="folder_uri"><?php esc_html_e( 'Folder', 'vimeify' ); ?></label>
                                <select id="folder_uri" name="folder_uri" class="vimeify-select2" data-action="vimeify_folder_search"
                                        data-placeholder="<?php esc_html_e( 'Select folder...', 'vimeify' ); ?>">
                                    <option value="default" <?php selected( 'default', $default_folder_uri ); ?>><?php esc_html_e( 'Default (no folder)', 'vimeify' ); ?></option>
                                    <?php if ( ! empty( $default_folder_uri ) ): ?>
                                        <option selected value="<?php echo esc_attr( $default_folder_uri ); ?>"><?php echo esc_html( $default_folder_name ); ?></option>
                                    <?php endif; ?>
                                </select>
                            </div>
                        <?php endif; ?>

                        <div class="form-row">
                            <label for="vimeo_categories"><?php esc_html_e( 'Categories', 'vimeify' ); ?></label>
                            <?php
                            $categories = get_terms( array(
                                'taxonomy'   => \Vimeify\Core\Components\Database::TAXONOMY_CATEGORY,
                                'hide_empty' => false,
                            ) );
                            ?>
                            <select id="vimeo_categories" name="vimeo_categories[]" multiple="multiple" class="vimeify-categories-select"
                                    data-placeholder="<?php esc_attr_e( 'Select categories (optional)...', 'vimeify' ); ?>">
                                <?php if ( ! empty( $categories ) && ! is_wp_error( $categories ) ): ?>
                                    <?php foreach ( $categories as $category ): ?>
                                        <option value="<?php echo esc_attr( $category->term_id ); ?>">
                                            <?php echo esc_html( $category->name ); ?>
                                        </option>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </select>
                        </div>
                    </div>
                </div>

                <div class="vimeify-upload-actions">
                    <button type="submit" class="button button-primary button-hero" name="vimeo_upload" value="1">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"></path>
                            <polyline points="17 8 12 3 7 8"></polyline>
                            <line x1="12" y1="3" x2="12" y2="15"></line>
                        </svg>
						<?php esc_html_e( 'Upload to Vimeo', 'vimeify' ); ?>
                    </button>
                </div>
            </form>
        </div>

	<?php else: ?>

		<?php if ( ! $plugin->system()->vimeo()->state->is_connected ): ?>

            <?php include 'not-connected.php'; ?>

		<?php elseif( ! $plugin->system()->vimeo()->can_upload() ): ?>

			<?php include 'not-allowed-upload.php'; ?>

		<?php endif; ?>

	<?php endif; ?>

</div>

