<?php
/********************************************************************
 * Copyright (C) 2024 Darko Gjorgjijoski (https://darkog.com/)
 * Copyright (C) 2024 IDEOLOGIX MEDIA Dooel (https://ideologix.com/)
 *
 * This file is property of IDEOLOGIX MEDIA Dooel (https://ideologix.com)
 * This file is part of Vimeify Plugin - https://wordpress.org/plugins/vimeify/
 *
 * Vimeify - Formerly "WP Vimeo Videos" is free software: you can redistribute
 * it and/or modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the License,
 * or (at your option) any later version.
 *
 * Vimeify - Formerly "WP Vimeo Videos" is distributed in the hope that it
 * will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this plugin. If not, see <https://www.gnu.org/licenses/>.
 *
 * Code developed by Darko Gjorgjijoski <dg@darkog.com>.
 **********************************************************************/

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/* @var \Vimeify\Core\Plugin $plugin */

$has_pro = defined( 'VIMEIFY_PRO_VERSION' );
$pro_feature_class = $has_pro ? 'vimeify-help-feature--pro' : 'vimeify-help-feature--locked';
?>

<div class="vimeify-wrap vimeify-wrap--with-header">
	<h1><?php esc_html_e( 'Help & Resources', 'vimeify' ); ?></h1>

	<div class="vimeify-help-container">
		<!-- Documentation Card -->
		<div class="vimeify-help-card vimeify-help-card--docs">
			<div class="vimeify-help-card__icon">
				<span class="dashicons dashicons-book-alt"></span>
			</div>
			<div class="vimeify-help-card__content">
				<h2><?php esc_html_e( 'Documentation', 'vimeify' ); ?></h2>
				<p><?php esc_html_e( 'Browse our comprehensive documentation to learn how to get the most out of Vimeify. Find tutorials, guides, and answers to common questions.', 'vimeify' ); ?></p>
				<a href="https://docs.vimeify.com" target="_blank" rel="noopener noreferrer" class="button button-primary button-hero">
					<?php esc_html_e( 'Visit Documentation', 'vimeify' ); ?>
					<span class="dashicons dashicons-external"></span>
				</a>
			</div>
		</div>

		<!-- Core Features Section -->
		<div class="vimeify-help-card">
			<h2><?php esc_html_e( 'Core Features', 'vimeify' ); ?></h2>
			<div class="vimeify-help-features">
				<div class="vimeify-help-feature">
					<span class="dashicons dashicons-video-alt3"></span>
					<div class="vimeify-help-feature__content">
						<h3><?php esc_html_e( 'Video Management', 'vimeify' ); ?></h3>
						<p><?php esc_html_e( 'Upload, manage, and organize your Vimeo videos directly from WordPress.', 'vimeify' ); ?></p>
					</div>
				</div>

				<div class="vimeify-help-feature">
					<span class="dashicons dashicons-upload"></span>
					<div class="vimeify-help-feature__content">
						<h3><?php esc_html_e( 'Upload Profiles', 'vimeify' ); ?></h3>
						<p><?php esc_html_e( 'Configure default upload settings with reusable profiles for consistent video uploads.', 'vimeify' ); ?></p>
					</div>
				</div>

				<div class="vimeify-help-feature">
					<span class="dashicons dashicons-category"></span>
					<div class="vimeify-help-feature__content">
						<h3><?php esc_html_e( 'Video Categories', 'vimeify' ); ?></h3>
						<p><?php esc_html_e( 'Organize your videos with custom taxonomies for better content management.', 'vimeify' ); ?></p>
					</div>
				</div>

				<div class="vimeify-help-feature">
					<span class="dashicons dashicons-format-gallery"></span>
					<div class="vimeify-help-feature__content">
						<h3><?php esc_html_e( 'Video Galleries', 'vimeify' ); ?></h3>
						<p><?php esc_html_e( 'Create beautiful video galleries using shortcodes or Gutenberg blocks.', 'vimeify' ); ?></p>
					</div>
				</div>

				<div class="vimeify-help-feature">
					<span class="dashicons dashicons-block-default"></span>
					<div class="vimeify-help-feature__content">
						<h3><?php esc_html_e( 'Gutenberg Blocks', 'vimeify' ); ?></h3>
						<p><?php esc_html_e( 'Native WordPress block editor support for easy video embedding.', 'vimeify' ); ?></p>
					</div>
				</div>

				<div class="vimeify-help-feature">
					<span class="dashicons dashicons-editor-code"></span>
					<div class="vimeify-help-feature__content">
						<h3><?php esc_html_e( 'Page Builder Support', 'vimeify' ); ?></h3>
						<p><?php esc_html_e( 'Integration with popular page builders like Elementor and Bricks.', 'vimeify' ); ?></p>
					</div>
				</div>
			</div>
		</div>

		<!-- PRO Features Section -->
		<div class="vimeify-help-card vimeify-help-card--pro-section">
			<h2><?php esc_html_e( 'PRO Features', 'vimeify' ); ?></h2>

			<!-- Media & Galleries subsection -->
			<h3 class="vimeify-help-subsection"><?php esc_html_e( 'Media & Galleries', 'vimeify' ); ?></h3>
			<div class="vimeify-help-features">
				<div class="vimeify-help-feature <?php echo esc_attr( $pro_feature_class ); ?>">
					<span class="dashicons dashicons-admin-media"></span>
					<div class="vimeify-help-feature__content">
						<h3><?php esc_html_e( 'Media Library Integration', 'vimeify' ); ?></h3>
						<p><?php esc_html_e( 'Videos appear in WordPress Media Library with direct MP4 links (CDN-like access). Requires Vimeo Pro/Business account.', 'vimeify' ); ?></p>
					</div>
				</div>

				<div class="vimeify-help-feature <?php echo esc_attr( $pro_feature_class ); ?>">
					<span class="dashicons dashicons-playlist-video"></span>
					<div class="vimeify-help-feature__content">
						<h3><?php esc_html_e( 'Playlist Gallery Style', 'vimeify' ); ?></h3>
						<p><?php esc_html_e( 'Sophisticated layout with main player and side video list for professional presentations.', 'vimeify' ); ?></p>
					</div>
				</div>

				<div class="vimeify-help-feature <?php echo esc_attr( $pro_feature_class ); ?>">
					<span class="dashicons dashicons-grid-view"></span>
					<div class="vimeify-help-feature__content">
						<h3><?php esc_html_e( 'Videos Grid Gallery', 'vimeify' ); ?></h3>
						<p><?php esc_html_e( 'Responsive grid layout with thumbnails, metadata display, and customizable styling.', 'vimeify' ); ?></p>
					</div>
				</div>

				<div class="vimeify-help-feature <?php echo esc_attr( $pro_feature_class ); ?>">
					<span class="dashicons dashicons-portfolio"></span>
					<div class="vimeify-help-feature__content">
						<h3><?php esc_html_e( 'Folder Sync Galleries', 'vimeify' ); ?></h3>
						<p><?php esc_html_e( 'Auto-sync videos from Vimeo folders with automatic updates every 6 hours.', 'vimeify' ); ?></p>
					</div>
				</div>

				<div class="vimeify-help-feature <?php echo esc_attr( $pro_feature_class ); ?>">
					<span class="dashicons dashicons-image-filter"></span>
					<div class="vimeify-help-feature__content">
						<h3><?php esc_html_e( 'Lazy Load / Infinite Scroll', 'vimeify' ); ?></h3>
						<p><?php esc_html_e( 'AJAX-based loading for better performance with large video collections.', 'vimeify' ); ?></p>
					</div>
				</div>
			</div>

			<!-- Form Integrations subsection -->
			<h3 class="vimeify-help-subsection"><?php esc_html_e( 'Form Integrations', 'vimeify' ); ?></h3>
			<div class="vimeify-help-features">
				<div class="vimeify-help-feature <?php echo esc_attr( $pro_feature_class ); ?>">
					<span class="dashicons dashicons-feedback"></span>
					<div class="vimeify-help-feature__content">
						<h3><?php esc_html_e( 'WPForms Integration', 'vimeify' ); ?></h3>
						<p><?php esc_html_e( 'Custom Vimeo upload field with 3 styles: Classic, Modern (drag-drop + chunked uploads), and Modern Popup.', 'vimeify' ); ?></p>
					</div>
				</div>

				<div class="vimeify-help-feature <?php echo esc_attr( $pro_feature_class ); ?>">
					<span class="dashicons dashicons-forms"></span>
					<div class="vimeify-help-feature__content">
						<h3><?php esc_html_e( 'Gravity Forms Integration', 'vimeify' ); ?></h3>
						<p><?php esc_html_e( 'Custom upload field with Classic and Modern styles for Gravity Forms.', 'vimeify' ); ?></p>
					</div>
				</div>

				<div class="vimeify-help-feature <?php echo esc_attr( $pro_feature_class ); ?>">
					<span class="dashicons dashicons-rest-api"></span>
					<div class="vimeify-help-feature__content">
						<h3><?php esc_html_e( 'CustomForms API', 'vimeify' ); ?></h3>
						<p><?php esc_html_e( 'Developer API for building custom form integrations with third-party form builders.', 'vimeify' ); ?></p>
					</div>
				</div>

				<div class="vimeify-help-feature <?php echo esc_attr( $pro_feature_class ); ?>">
					<span class="dashicons dashicons-upload"></span>
					<div class="vimeify-help-feature__content">
						<h3><?php esc_html_e( 'Chunked Uploads', 'vimeify' ); ?></h3>
						<p><?php esc_html_e( 'Reliable large file uploads with resume capability and progress tracking.', 'vimeify' ); ?></p>
					</div>
				</div>
			</div>

			<!-- Page Builders subsection -->
			<h3 class="vimeify-help-subsection"><?php esc_html_e( 'Page Builders', 'vimeify' ); ?></h3>
			<div class="vimeify-help-features">
				<div class="vimeify-help-feature <?php echo esc_attr( $pro_feature_class ); ?>">
					<span class="dashicons dashicons-search"></span>
					<div class="vimeify-help-feature__content">
						<h3><?php esc_html_e( 'ACF Selection Field', 'vimeify' ); ?></h3>
						<p><?php esc_html_e( 'Search and select existing Vimeo videos from Advanced Custom Fields.', 'vimeify' ); ?></p>
					</div>
				</div>

				<div class="vimeify-help-feature <?php echo esc_attr( $pro_feature_class ); ?>">
					<span class="dashicons dashicons-cloud-upload"></span>
					<div class="vimeify-help-feature__content">
						<h3><?php esc_html_e( 'ACF Upload Field', 'vimeify' ); ?></h3>
						<p><?php esc_html_e( 'Upload new videos to Vimeo directly from ACF fields.', 'vimeify' ); ?></p>
					</div>
				</div>

				<div class="vimeify-help-feature <?php echo esc_attr( $pro_feature_class ); ?>">
					<span class="dashicons dashicons-screenoptions"></span>
					<div class="vimeify-help-feature__content">
						<h3><?php esc_html_e( 'Elementor Videos Grid Widget', 'vimeify' ); ?></h3>
						<p><?php esc_html_e( 'Full visual builder support with videos grid widget for Elementor.', 'vimeify' ); ?></p>
					</div>
				</div>

				<div class="vimeify-help-feature <?php echo esc_attr( $pro_feature_class ); ?>">
					<span class="dashicons dashicons-layout"></span>
					<div class="vimeify-help-feature__content">
						<h3><?php esc_html_e( 'Bricks Videos Grid Element', 'vimeify' ); ?></h3>
						<p><?php esc_html_e( 'Native Bricks integration with videos grid element.', 'vimeify' ); ?></p>
					</div>
				</div>
			</div>

			<!-- LMS Platforms subsection -->
			<h3 class="vimeify-help-subsection"><?php esc_html_e( 'LMS Platforms', 'vimeify' ); ?></h3>
			<div class="vimeify-help-features">
				<div class="vimeify-help-feature <?php echo esc_attr( $pro_feature_class ); ?>">
					<span class="dashicons dashicons-welcome-learn-more"></span>
					<div class="vimeify-help-feature__content">
						<h3><?php esc_html_e( 'LearnDash Integration', 'vimeify' ); ?></h3>
						<p><?php esc_html_e( 'Video upload directly in lesson and topic editors for LearnDash courses.', 'vimeify' ); ?></p>
					</div>
				</div>
			</div>

			<!-- Advanced Features subsection -->
			<h3 class="vimeify-help-subsection"><?php esc_html_e( 'Advanced Features', 'vimeify' ); ?></h3>
			<div class="vimeify-help-features">
				<div class="vimeify-help-feature <?php echo esc_attr( $pro_feature_class ); ?>">
					<span class="dashicons dashicons-shield"></span>
					<div class="vimeify-help-feature__content">
						<h3><?php esc_html_e( 'Embed Privacy Management', 'vimeify' ); ?></h3>
						<p><?php esc_html_e( 'Domain whitelist for video embedding to control where videos can be displayed.', 'vimeify' ); ?></p>
					</div>
				</div>

				<div class="vimeify-help-feature <?php echo esc_attr( $pro_feature_class ); ?>">
					<span class="dashicons dashicons-lock"></span>
					<div class="vimeify-help-feature__content">
						<h3><?php esc_html_e( 'View Privacy Control', 'vimeify' ); ?></h3>
						<p><?php esc_html_e( 'Role-based access control for videos with granular permissions.', 'vimeify' ); ?></p>
					</div>
				</div>

				<div class="vimeify-help-feature <?php echo esc_attr( $pro_feature_class ); ?>">
					<span class="dashicons dashicons-groups"></span>
					<div class="vimeify-help-feature__content">
						<h3><?php esc_html_e( 'Frontend Upload', 'vimeify' ); ?></h3>
						<p><?php esc_html_e( 'Allow users to upload videos from the frontend of your website.', 'vimeify' ); ?></p>
					</div>
				</div>
			</div>
		</div>

		<!-- Support Card -->
		<div class="vimeify-help-card">
			<h2><?php esc_html_e( 'Need Help?', 'vimeify' ); ?></h2>
			<div class="vimeify-help-support-options">
				<a href="https://docs.vimeify.com" target="_blank" rel="noopener noreferrer" class="vimeify-help-support-option">
					<span class="dashicons dashicons-book"></span>
					<span><?php esc_html_e( 'Documentation', 'vimeify' ); ?></span>
				</a>
				<?php if ( $has_pro ) : ?>
				<a href="https://codeverve.com/my-account" target="_blank" rel="noopener noreferrer" class="vimeify-help-support-option">
					<span class="dashicons dashicons-sos"></span>
					<span><?php esc_html_e( 'Support', 'vimeify' ); ?></span>
				</a>
				<?php else : ?>
				<a href="https://wordpress.org/support/plugin/vimeify/" target="_blank" rel="noopener noreferrer" class="vimeify-help-support-option">
					<span class="dashicons dashicons-sos"></span>
					<span><?php esc_html_e( 'Support Forum', 'vimeify' ); ?></span>
				</a>
				<?php endif; ?>
				<a href="https://vimeify.com" target="_blank" rel="noopener noreferrer" class="vimeify-help-support-option">
					<span class="dashicons dashicons-admin-site-alt3"></span>
					<span><?php esc_html_e( 'Website', 'vimeify' ); ?></span>
				</a>
			</div>
		</div>
	</div>
</div>
