<?php
/********************************************************************
 * Copyright (C) 2024 Darko Gjorgjijoski (https://darkog.com/)
 * Copyright (C) 2024 IDEOLOGIX MEDIA Dooel (https://ideologix.com/)
 *
 * This file is property of IDEOLOGIX MEDIA Dooel (https://ideologix.com)
 * This file is part of Vimeify Plugin - https://wordpress.org/plugins/vimeify/
 *
 * Vimeify - Formerly "WP Vimeo Videos" is free software: you can redistribute
 * it and/or modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the License,
 * or (at your option) any later version.
 *
 * Vimeify - Formerly "WP Vimeo Videos" is distributed in the hope that it
 * will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this plugin. If not, see <https://www.gnu.org/licenses/>.
 *
 * Code developed by Darko Gjorgjijoski <dg@darkog.com>.
 **********************************************************************/

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/* @var \Vimeify\Core\Plugin $plugin */

// Get current page
$current_page = isset( $_GET['page'] ) ? sanitize_text_field( $_GET['page'] ) : '';

// Detect special pages (Profiles, Categories)
global $pagenow;
$post_type = isset( $_GET['post_type'] ) ? sanitize_text_field( $_GET['post_type'] ) : '';
$taxonomy  = isset( $_GET['taxonomy'] ) ? sanitize_text_field( $_GET['taxonomy'] ) : '';

// Check for Upload Profiles pages
if ( in_array( $pagenow, array( 'edit.php', 'post.php', 'post-new.php' ) ) && $post_type === 'vimeify-profile' ) {
	$current_page = 'vimeify-profiles';
}
// Also check when editing a single profile (post_type not in URL)
if ( $pagenow === 'post.php' && isset( $_GET['post'] ) && get_post_type( intval( $_GET['post'] ) ) === 'vimeify-profile' ) {
	$current_page = 'vimeify-profiles';
}

// Check for Categories pages
if ( in_array( $pagenow, array( 'edit-tags.php', 'term.php' ) ) && $taxonomy === 'vimeify-category' ) {
	$current_page = 'vimeify-categories';
}

// Check if PRO version is active
$has_pro = defined( 'VIMEIFY_PRO_VERSION' );

// Primary navigation items (always visible)
$primary_items = array(
	array(
		'slug'  => 'vimeify',
		'label' => __( 'Videos', 'vimeify' ),
		'url'   => admin_url( 'admin.php?page=vimeify' ),
	),
	array(
		'slug'  => 'vimeify-video',
		'label' => __( 'Upload', 'vimeify' ),
		'url'   => admin_url( 'admin.php?page=vimeify-video' ),
	),
	array(
		'slug'  => 'vimeify-profiles',
		'label' => __( 'Profiles', 'vimeify' ),
		'url'   => admin_url( 'edit.php?post_type=vimeify-profile' ),
	),
	array(
		'slug'  => 'vimeify-categories',
		'label' => __( 'Categories', 'vimeify' ),
		'url'   => admin_url( 'edit-tags.php?taxonomy=vimeify-category&post_type=vimeify-video' ),
	),
	array(
		'slug'  => 'vimeify-galleries',
		'label' => __( 'Galleries', 'vimeify' ),
		'url'   => admin_url( 'admin.php?page=vimeify-galleries' ),
	),
	array(
		'slug'  => 'vimeify-help',
		'label' => __( 'Help', 'vimeify' ),
		'url'   => admin_url( 'admin.php?page=vimeify-help' ),
	),
);

// Dropdown items (inside "More" menu)
$dropdown_items = array(
	array(
		'slug'  => 'vimeify-tools',
		'label' => __( 'Tools', 'vimeify' ),
		'url'   => admin_url( 'admin.php?page=vimeify-tools' ),
	),
	array(
		'slug'  => 'vimeify-settings',
		'label' => __( 'Settings', 'vimeify' ),
		'url'   => admin_url( 'admin.php?page=vimeify-settings' ),
	),
);

// Add License menu item when PRO is active
if ( $has_pro ) {
	$dropdown_items[] = array(
		'slug'  => 'vimeify-license',
		'label' => __( 'License', 'vimeify' ),
		'url'   => admin_url( 'admin.php?page=vimeify-license' ),
	);
}

// Check if current page is in dropdown items
$is_dropdown_active = false;
foreach ( $dropdown_items as $item ) {
	if ( $current_page === $item['slug'] ) {
		$is_dropdown_active = true;
		break;
	}
}
?>

<div class="vimeify-header-bar">
	<div class="vimeify-header-bar__inner">
		<div class="vimeify-header-bar__brand">
			<a href="<?php echo esc_url( admin_url( 'admin.php?page=vimeify' ) ); ?>" class="vimeify-header-bar__logo">
				<img src="<?php echo esc_url( $plugin->icon() ); ?>" alt="<?php esc_attr_e( 'Vimeify', 'vimeify' ); ?>" width="32" height="32">
				<span class="vimeify-header-bar__title"><?php esc_html_e( 'Vimeify', 'vimeify' ); ?></span>
			</a>
		</div>
		<button type="button" class="vimeify-header-bar__toggle" aria-label="<?php esc_attr_e( 'Toggle menu', 'vimeify' ); ?>" aria-expanded="false">
			<span class="vimeify-header-bar__toggle-icon"></span>
		</button>
		<nav class="vimeify-header-bar__nav">
			<?php foreach ( $primary_items as $item ) : ?>
				<?php
				$is_active = ( $current_page === $item['slug'] );
				$class     = 'vimeify-header-bar__nav-item';
				if ( $is_active ) {
					$class .= ' vimeify-header-bar__nav-item--active';
				}
				?>
				<a href="<?php echo esc_url( $item['url'] ); ?>" class="<?php echo esc_attr( $class ); ?>">
					<?php echo esc_html( $item['label'] ); ?>
				</a>
			<?php endforeach; ?>

			<!-- More dropdown -->
			<div class="vimeify-header-bar__more">
				<button type="button" class="vimeify-header-bar__more-toggle<?php echo $is_dropdown_active ? ' vimeify-header-bar__more-toggle--active' : ''; ?>" aria-expanded="false" aria-label="<?php esc_attr_e( 'More options', 'vimeify' ); ?>">
					<span class="dashicons dashicons-ellipsis"></span>
				</button>
				<div class="vimeify-header-bar__more-menu">
					<?php foreach ( $dropdown_items as $item ) : ?>
						<?php
						$is_active = ( $current_page === $item['slug'] );
						$class     = 'vimeify-header-bar__more-item';
						if ( $is_active ) {
							$class .= ' vimeify-header-bar__more-item--active';
						}
						?>
						<a href="<?php echo esc_url( $item['url'] ); ?>" class="<?php echo esc_attr( $class ); ?>">
							<?php echo esc_html( $item['label'] ); ?>
						</a>
					<?php endforeach; ?>
				</div>
			</div>

			<?php if ( ! $has_pro ) : ?>
				<a href="https://vimeify.com/get-pro" target="_blank" rel="noopener noreferrer" class="vimeify-header-bar__cta">
					<?php esc_html_e( 'Get PRO', 'vimeify' ); ?>
				</a>
			<?php endif; ?>
		</nav>
	</div>
</div>
