<?php
/**
 * Galleries Admin Page
 *
 * @var \Vimeify\Core\Plugin $plugin
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

$action = isset( $_GET['action'] ) ? sanitize_text_field( $_GET['action'] ) : '';
$gallery_id = isset( $_GET['gallery_id'] ) ? intval( $_GET['gallery_id'] ) : 0;

// Show add/edit form
if ( in_array( $action, [ 'add', 'edit' ] ) ) {
	include __DIR__ . '/galleries-form.php';
	return;
}

// List galleries
$galleries = get_terms( [
	'taxonomy'   => \Vimeify\Core\Components\Database::TAXONOMY_GALLERY,
	'hide_empty' => false,
] );

// Get gallery types for display
$galleries_handler = new \Vimeify\Core\Backend\Galleries( $plugin );
$gallery_types = $galleries_handler->get_gallery_types();
?>
<?php include __DIR__ . '/header-bar.php'; ?>
<div class="wrap vimeify-wrap--with-header">
	<h1 class="wp-heading-inline"><?php esc_html_e( 'Galleries', 'vimeify' ); ?></h1>
	<a href="<?php echo esc_url( add_query_arg( [ 'page' => \Vimeify\Core\Backend\Ui::PAGE_GALLERIES, 'action' => 'add' ], admin_url( 'admin.php' ) ) ); ?>" class="page-title-action">
		<?php esc_html_e( 'Add New', 'vimeify' ); ?>
	</a>
	<hr class="wp-header-end">

	<?php if ( isset( $_GET['message'] ) ) : ?>
		<div class="notice notice-success is-dismissible">
			<p>
				<?php if ( $_GET['message'] === 'saved' ) : ?>
					<?php esc_html_e( 'Gallery saved successfully.', 'vimeify' ); ?>
				<?php elseif ( $_GET['message'] === 'deleted' ) : ?>
					<?php esc_html_e( 'Gallery deleted successfully.', 'vimeify' ); ?>
				<?php endif; ?>
			</p>
		</div>
	<?php endif; ?>

	<table class="wp-list-table widefat fixed striped" style="margin-top: 20px;">
		<thead>
			<tr>
				<th><?php esc_html_e( 'Name', 'vimeify' ); ?></th>
				<th><?php esc_html_e( 'Type', 'vimeify' ); ?></th>
				<th><?php esc_html_e( 'Videos', 'vimeify' ); ?></th>
				<th><?php esc_html_e( 'Settings', 'vimeify' ); ?></th>
			</tr>
		</thead>
		<tbody>
			<?php if ( empty( $galleries ) ) : ?>
				<tr>
					<td colspan="4"><?php esc_html_e( 'No galleries found. Create your first gallery!', 'vimeify' ); ?></td>
				</tr>
			<?php else : ?>
				<?php foreach ( $galleries as $gallery ) : ?>
					<?php
					$gallery_type = \Vimeify\Core\Backend\Galleries::get_gallery_type( $gallery->term_id );
					$type_label = isset( $gallery_types[ $gallery_type ] ) ? $gallery_types[ $gallery_type ]['label'] : ucfirst( $gallery_type );
					$videos = \Vimeify\Core\Backend\Galleries::get_gallery_videos( $gallery->term_id );
					$settings = \Vimeify\Core\Backend\Galleries::get_gallery_settings( $gallery->term_id );
					$edit_url = add_query_arg( [
						'page' => \Vimeify\Core\Backend\Ui::PAGE_GALLERIES,
						'action' => 'edit',
						'gallery_id' => $gallery->term_id
					], admin_url( 'admin.php' ) );
					$delete_url = wp_nonce_url( add_query_arg( [
						'page' => \Vimeify\Core\Backend\Ui::PAGE_GALLERIES,
						'action' => 'delete',
						'gallery_id' => $gallery->term_id
					], admin_url( 'admin.php' ) ), 'delete_gallery_' . $gallery->term_id );
					$preview_url = add_query_arg( [
						'vimeify-gallery-preview' => $gallery->term_id
					], home_url( '/' ) );
					?>
					<tr>
						<td>
							<strong><a href="<?php echo esc_url( $edit_url ); ?>"><?php echo esc_html( $gallery->name ); ?></a></strong>
							<div class="row-actions">
								<span class="edit"><a href="<?php echo esc_url( $edit_url ); ?>"><?php esc_html_e( 'Edit', 'vimeify' ); ?></a> | </span>
								<span class="delete"><a href="<?php echo esc_url( $delete_url ); ?>" onclick="return confirm('<?php esc_attr_e( 'Are you sure you want to delete this gallery?', 'vimeify' ); ?>')"><?php esc_html_e( 'Delete', 'vimeify' ); ?></a> | </span>
								<span class="view"><a href="<?php echo esc_url( $preview_url ); ?>" target="_blank"><?php esc_html_e( 'Preview', 'vimeify' ); ?></a></span>
							</div>
						</td>
						<td><?php echo esc_html( $type_label ); ?></td>
						<td><?php echo count( $videos ); ?> <?php esc_html_e( 'videos', 'vimeify' ); ?></td>
						<td>
							<?php if ( ! empty( $settings ) ) : ?>
								<?php echo esc_html( count( $settings ) ); ?> <?php esc_html_e( 'settings configured', 'vimeify' ); ?>
							<?php else : ?>
								<span class="description"><?php esc_html_e( 'Using defaults', 'vimeify' ); ?></span>
							<?php endif; ?>
						</td>
					</tr>
				<?php endforeach; ?>
			<?php endif; ?>
		</tbody>
	</table>
</div>
