<?php
/**
 * Gallery Add/Edit Form
 *
 * @var \Vimeify\Core\Plugin $plugin
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

$action = isset( $_GET['action'] ) ? sanitize_text_field( $_GET['action'] ) : 'add';
$gallery_id = isset( $_GET['gallery_id'] ) ? intval( $_GET['gallery_id'] ) : 0;
$is_edit = $action === 'edit' && $gallery_id > 0;

// Get gallery data if editing
$gallery_name = '';
$gallery_type = 'selection';
$gallery_videos = [];
$gallery_settings = [];

if ( $is_edit ) {
	$gallery = get_term( $gallery_id, \Vimeify\Core\Components\Database::TAXONOMY_GALLERY );
	if ( ! $gallery || is_wp_error( $gallery ) ) {
		wp_die( __( 'Gallery not found.', 'vimeify' ) );
	}
	$gallery_name = $gallery->name;
	$gallery_type = \Vimeify\Core\Backend\Galleries::get_gallery_type( $gallery_id );
	$gallery_videos = \Vimeify\Core\Backend\Galleries::get_gallery_videos( $gallery_id );
	$gallery_settings = \Vimeify\Core\Backend\Galleries::get_gallery_settings( $gallery_id );
}

// Get all videos for picker
$videos = get_posts( [
	'post_type' => \Vimeify\Core\Components\Database::POST_TYPE_VIDEO,
	'posts_per_page' => -1,
	'orderby' => 'title',
	'order' => 'ASC',
] );

// Get settings fields and gallery types
$galleries_handler = new \Vimeify\Core\Backend\Galleries( $plugin );
$display_style = isset( $gallery_settings['display_style'] ) ? $gallery_settings['display_style'] : 'slider';
$settings_fields = $galleries_handler->get_settings_fields( $display_style, $gallery_type );
$gallery_types = $galleries_handler->get_gallery_types();
$display_styles = $galleries_handler->get_display_styles();
?>
<?php include __DIR__ . '/header-bar.php'; ?>
<div class="wrap vimeify-wrap--with-header">
	<h1 class="wp-heading-inline">
		<?php echo $is_edit ? esc_html__( 'Edit Gallery', 'vimeify' ) : esc_html__( 'Add New Gallery', 'vimeify' ); ?>
	</h1>
	<?php if ( $is_edit ) : ?>
		<a href="<?php echo esc_url( add_query_arg( [ 'vimeify-gallery-preview' => $gallery_id ], home_url( '/' ) ) ); ?>" class="page-title-action" target="_blank">
			<?php esc_html_e( 'Preview Gallery', 'vimeify' ); ?>
		</a>
	<?php endif; ?>
	<a href="<?php echo esc_url( admin_url( 'admin.php?page=' . \Vimeify\Core\Backend\Ui::PAGE_GALLERIES ) ); ?>" class="page-title-action">
		<?php esc_html_e( 'Back to Galleries', 'vimeify' ); ?>
	</a>
	<hr class="wp-header-end">

	<?php if ( isset( $_GET['message'] ) && $_GET['message'] === 'saved' ) : ?>
		<div class="notice notice-success is-dismissible">
			<p><?php esc_html_e( 'Gallery saved successfully.', 'vimeify' ); ?></p>
		</div>
	<?php endif; ?>

	<?php if ( isset( $_GET['error'] ) ) : ?>
		<div class="notice notice-error is-dismissible">
			<p>
				<?php if ( $_GET['error'] === 'empty_name' ) : ?>
					<?php esc_html_e( 'Gallery name cannot be empty.', 'vimeify' ); ?>
				<?php elseif ( $_GET['error'] === 'save_failed' ) : ?>
					<?php esc_html_e( 'Failed to save gallery. Please try again.', 'vimeify' ); ?>
				<?php endif; ?>
			</p>
		</div>
	<?php endif; ?>

	<form method="post" action="">
		<?php wp_nonce_field( 'vimeify_gallery_save' ); ?>
		<input type="hidden" name="vimeify_save_gallery" value="1">
		<?php if ( $is_edit ) : ?>
			<input type="hidden" name="gallery_id" value="<?php echo esc_attr( $gallery_id ); ?>">
		<?php endif; ?>

		<div id="poststuff">
			<div id="post-body" class="metabox-holder columns-2">
				<div id="post-body-content">
					<!-- Gallery Name -->
					<div class="postbox">
						<div class="postbox-header">
							<h2><?php esc_html_e( 'Gallery Name', 'vimeify' ); ?></h2>
						</div>
						<div class="inside">
							<input type="text" name="gallery_name" id="gallery_name" value="<?php echo esc_attr( $gallery_name ); ?>" class="widefat" required>
						</div>
					</div>

					<!-- Gallery Type -->
					<div class="postbox">
						<div class="postbox-header">
							<h2><?php esc_html_e( 'Gallery Type', 'vimeify' ); ?></h2>
						</div>
						<div class="inside" style="padding: 15px;">
							<div class="vimeify-gallery-type-cards">
								<?php foreach ( $gallery_types as $type ) : ?>
									<?php
									$is_premium = isset( $type['premium'] ) && $type['premium'];
									$is_disabled = $is_premium;
									?>
									<label class="vimeify-type-card <?php echo $is_premium ? 'vimeify-type-card-premium' : ''; ?> <?php echo $is_disabled ? 'vimeify-type-card-disabled' : ''; ?>">
										<input type="radio"
											name="gallery_type"
											value="<?php echo esc_attr( $type['id'] ); ?>"
											<?php checked( $gallery_type, $type['id'] ); ?>
											<?php disabled( $is_disabled ); ?>
											class="vimeify-gallery-type-radio">
										<div class="vimeify-type-card-content">
											<div class="vimeify-type-card-header">
												<span class="vimeify-type-card-title"><?php echo esc_html( $type['label'] ); ?></span>
												<?php if ( $is_premium ) : ?>
													<span class="vimeify-type-card-badge"><?php esc_html_e( 'PRO', 'vimeify' ); ?></span>
												<?php endif; ?>
											</div>
											<?php if ( ! empty( $type['desc'] ) ) : ?>
												<p class="vimeify-type-card-desc"><?php echo esc_html( $type['desc'] ); ?></p>
											<?php endif; ?>
											<?php if ( $is_disabled ) : ?>
												<p class="vimeify-type-card-upgrade">
													<a href="https://vimeify.com/pricing" target="_blank"><?php esc_html_e( 'Upgrade to Pro', 'vimeify' ); ?> →</a>
												</p>
											<?php endif; ?>
										</div>
									</label>
								<?php endforeach; ?>
							</div>
						</div>
					</div>

					<!-- Gallery Content Tabs (for all types) -->
					<?php foreach ( $gallery_types as $type_id => $type_config ) : ?>
						<div class="postbox vimeify-gallery-content-tabs vimeify-gallery-type-section" data-type="<?php echo esc_attr( $type_id ); ?>">
							<div class="postbox-header">
								<h2><?php esc_html_e( 'Gallery Content', 'vimeify' ); ?></h2>
							</div>
							<div class="inside" style="padding: 0;">
								<div class="vimeify-tabs-wrapper">
									<!-- Left sidebar tabs -->
									<div class="vimeify-tabs-nav">
										<ul>
											<li class="vimeify-tab-link active" data-tab="content-<?php echo esc_attr( $type_id ); ?>">
												<span class="dashicons dashicons-video-alt3"></span>
												<?php
												if ( $type_id === 'selection' ) {
													esc_html_e( 'Videos', 'vimeify' );
												} elseif ( $type_id === 'folder_sync' ) {
													esc_html_e( 'Vimeo Folder', 'vimeify-pro' );
												} else {
													echo esc_html( $type_config['label'] );
												}
												?>
											</li>
											<li class="vimeify-tab-link" data-tab="settings-<?php echo esc_attr( $type_id ); ?>">
												<span class="dashicons dashicons-admin-settings"></span>
												<?php esc_html_e( 'Display Options', 'vimeify' ); ?>
											</li>
										</ul>
									</div>

									<!-- Tab content -->
									<div class="vimeify-tabs-content">
										<!-- Content Tab (Videos or Folder Selector) -->
										<div class="vimeify-tab-pane active" data-tab-pane="content-<?php echo esc_attr( $type_id ); ?>">
											<?php if ( $type_id === 'selection' ) : ?>
												<!-- Videos Picker for selection type -->
						<div class="inside">
							<div class="vimeify-gallery-videos-wrapper">
								<div class="vimeify-video-picker">
									<div class="vimeify-video-picker-search">
										<input type="text" id="vimeify-video-search" placeholder="<?php esc_attr_e( 'Search videos...', 'vimeify' ); ?>" class="widefat">
									</div>

									<div class="vimeify-video-picker-lists">
										<!-- Available Videos -->
										<div class="vimeify-video-list available-videos">
											<h3><?php esc_html_e( 'Available Videos', 'vimeify' ); ?></h3>
											<ul id="available-videos-list" class="video-items-list">
												<?php foreach ( $videos as $video ) : ?>
													<?php if ( ! in_array( $video->ID, $gallery_videos ) ) : ?>
														<li class="video-item" data-video-id="<?php echo esc_attr( $video->ID ); ?>">
															<span class="video-title"><?php echo esc_html( $video->post_title ); ?></span>
															<button type="button" class="button button-small add-video"><?php esc_html_e( 'Add', 'vimeify' ); ?></button>
														</li>
													<?php endif; ?>
												<?php endforeach; ?>
											</ul>
										</div>

										<!-- Selected Videos -->
										<div class="vimeify-video-list selected-videos">
											<h3><?php esc_html_e( 'Selected Videos', 'vimeify' ); ?></h3>
											<ul id="selected-videos-list" class="video-items-list sortable">
												<?php foreach ( $gallery_videos as $video_id ) : ?>
													<?php $video = get_post( $video_id ); ?>
													<?php if ( $video ) : ?>
														<li class="video-item" data-video-id="<?php echo esc_attr( $video->ID ); ?>">
															<span class="dashicons dashicons-move"></span>
															<span class="video-title"><?php echo esc_html( $video->post_title ); ?></span>
															<button type="button" class="button button-small remove-video"><?php esc_html_e( 'Remove', 'vimeify' ); ?></button>
															<input type="hidden" name="vimeify_gallery_videos[]" value="<?php echo esc_attr( $video->ID ); ?>">
														</li>
													<?php endif; ?>
												<?php endforeach; ?>
											</ul>
										</div>
									</div>
								</div>
							</div>

							<style>
								.vimeify-gallery-videos-wrapper {
									padding: 15px;
								}
								.vimeify-video-picker-search {
									margin-bottom: 15px;
								}
								.vimeify-video-picker-lists {
									display: grid;
									grid-template-columns: 1fr 1fr;
									gap: 20px;
								}
								.vimeify-video-list {
									border: 1px solid #ddd;
									border-radius: 4px;
									background: #f9f9f9;
								}
								.vimeify-video-list h3 {
									margin: 0;
									padding: 10px 15px;
									background: #fff;
									border-bottom: 1px solid #ddd;
									font-size: 14px;
								}
								.video-items-list {
									margin: 0;
									padding: 10px;
									list-style: none;
									min-height: 300px;
									max-height: 400px;
									overflow-y: auto;
								}
								.video-item {
									display: flex;
									align-items: center;
									padding: 8px 10px;
									margin-bottom: 5px;
									background: #fff;
									border: 1px solid #ddd;
									border-radius: 3px;
									cursor: default;
								}
								.video-item .video-title {
									flex: 1;
									margin-right: 10px;
								}
								.sortable .video-item {
									cursor: move;
								}
								.sortable .video-item .dashicons-move {
									margin-right: 8px;
									color: #999;
								}
								.video-item.ui-sortable-placeholder {
									border: 2px dashed #0073aa;
									background: #f0f6fc;
									visibility: visible !important;
								}

								/* Tabs styling */
								.vimeify-tabs-wrapper {
									display: flex;
									min-height: 400px;
								}

								.vimeify-tabs-nav {
									flex: 0 0 200px;
									border-right: 1px solid #c3c4c7;
									background: #f6f7f7;
								}

								.vimeify-tabs-nav ul {
									margin: 0;
									padding: 0;
									list-style: none;
								}

								.vimeify-tab-link {
									margin: 0;
									padding: 12px 20px;
									cursor: pointer;
									border-left: 3px solid transparent;
									display: flex;
									align-items: center;
									gap: 8px;
									color: #50575e;
									transition: all 0.2s ease;
								}

								.vimeify-tab-link:hover {
									background: #fff;
									color: #2271b1;
								}

								.vimeify-tab-link.active {
									background: #fff;
									border-left-color: #2271b1;
									color: #2271b1;
									font-weight: 600;
								}

								.vimeify-tab-link .dashicons {
									font-size: 18px;
									width: 18px;
									height: 18px;
								}

								.vimeify-tabs-content {
									flex: 1;
									padding: 20px;
									background: #fff;
								}

								.vimeify-tab-pane {
									display: none;
								}

								.vimeify-tab-pane.active {
									display: block;
								}
							</style>

							<script>
							jQuery(document).ready(function($) {
								// Tab switching
								$('.vimeify-tab-link').on('click', function() {
									var tab = $(this).data('tab');

									// Update tab navigation
									$('.vimeify-tab-link').removeClass('active');
									$(this).addClass('active');

									// Update tab content
									$('.vimeify-tab-pane').removeClass('active');
									$('.vimeify-tab-pane[data-tab-pane="' + tab + '"]').addClass('active');
								});

								// Make selected videos sortable
								$('#selected-videos-list').sortable({
									placeholder: 'ui-sortable-placeholder',
									update: function(event, ui) {
										// Order is automatically maintained by the DOM
									}
								});

								// Add video
								$(document).on('click', '.add-video', function() {
									var $item = $(this).closest('.video-item');
									var videoId = $item.data('video-id');
									var videoTitle = $item.find('.video-title').text();

									// Create selected item
									var $selectedItem = $('<li class="video-item" data-video-id="' + videoId + '">' +
										'<span class="dashicons dashicons-move"></span>' +
										'<span class="video-title">' + videoTitle + '</span>' +
										'<button type="button" class="button button-small remove-video"><?php esc_html_e( 'Remove', 'vimeify' ); ?></button>' +
										'<input type="hidden" name="vimeify_gallery_videos[]" value="' + videoId + '">' +
										'</li>');

									$('#selected-videos-list').append($selectedItem);
									$item.remove();
								});

								// Remove video
								$(document).on('click', '.remove-video', function() {
									var $item = $(this).closest('.video-item');
									var videoId = $item.data('video-id');
									var videoTitle = $item.find('.video-title').text();

									// Create available item
									var $availableItem = $('<li class="video-item" data-video-id="' + videoId + '">' +
										'<span class="video-title">' + videoTitle + '</span>' +
										'<button type="button" class="button button-small add-video"><?php esc_html_e( 'Add', 'vimeify' ); ?></button>' +
										'</li>');

									$('#available-videos-list').append($availableItem);
									$item.remove();

									// Sort available list alphabetically
									var $list = $('#available-videos-list');
									var $items = $list.children('.video-item');
									$items.sort(function(a, b) {
										return $(a).find('.video-title').text().localeCompare($(b).find('.video-title').text());
									});
									$list.append($items);
								});

								// Search functionality
								$('#vimeify-video-search').on('keyup', function() {
									var searchTerm = $(this).val().toLowerCase();
									$('.video-item').each(function() {
										var videoTitle = $(this).find('.video-title').text().toLowerCase();
										if (videoTitle.indexOf(searchTerm) > -1) {
											$(this).show();
										} else {
											$(this).hide();
										}
									});
								});

								// Gallery type switcher
								function toggleGalleryTypeSections() {
									var selectedType = $('input[name="gallery_type"]:checked').val();
									$('.vimeify-gallery-type-section').each(function() {
										var sectionType = $(this).data('type');
										if (sectionType === selectedType) {
											$(this).show();
										} else {
											$(this).hide();
										}
									});
								}

								// Initialize on load
								toggleGalleryTypeSections();

								// Update on type change
								$('.vimeify-gallery-type-radio').on('change', function() {
									toggleGalleryTypeSections();
								});

								// Gallery type and display style change handlers
								function updateTypeSpecificSettings() {
									var selectedType = $('input[name="gallery_type"]:checked').val();

									// Hide all type-specific setting fields
									$('.vimeify-type-specific-setting').hide();

									// Show only the fields for the selected type
									$('.vimeify-type-specific-setting[data-type="' + selectedType + '"]').show();
								}

								function updateStyleSpecificSettings() {
									var selectedStyle = $('#vimeify_setting_display_style').val();

									// Hide all style-specific setting fields
									$('.vimeify-style-specific-setting').hide();

									// Show only the fields for the selected style
									$('.vimeify-style-specific-setting[data-style="' + selectedStyle + '"]').show();
								}

								// Initialize on load
								updateTypeSpecificSettings();
								updateStyleSpecificSettings();

								// Update when gallery type changes
								$('.vimeify-gallery-type-radio').on('change', function() {
									updateTypeSpecificSettings();
								});

								// Update when display style changes
								$('#vimeify_setting_display_style').on('change', function() {
									updateStyleSpecificSettings();
								});

								// Sort available list alphabetically
								var $list = $('#available-videos-list');
								var $items = $list.children('.video-item');
								$items.sort(function(a, b) {
									return $(a).find('.video-title').text().localeCompare($(b).find('.video-title').text());
								});
								$list.append($items);
							});
							</script>
												</div>
											<?php else : ?>
												<!-- Other type content (e.g., folder sync) -->
												<?php do_action( 'vimeify_gallery_type_content_' . $type_id, $gallery_id, $is_edit, $plugin ); ?>
											<?php endif; ?>
										</div>

										<!-- Settings Tab -->
										<div class="vimeify-tab-pane" data-tab-pane="settings-<?php echo esc_attr( $type_id ); ?>">
											<?php if ( ! empty( $type_config['settings'] ) ) : ?>
												<table class="form-table" role="presentation">
													<tbody>
														<?php foreach ( $type_config['settings'] as $type_field ) : ?>
															<?php
															$field_id = $type_field['id'];
															$field_value = isset( $gallery_settings[ $field_id ] ) ? $gallery_settings[ $field_id ] : ( $type_field['default'] ?? '' );
															?>
															<tr>
																<th scope="row">
																	<label for="vimeify_setting_<?php echo esc_attr( $type_id ); ?>_<?php echo esc_attr( $field_id ); ?>">
																		<?php echo esc_html( $type_field['label'] ); ?>
																	</label>
																</th>
																<td>
																	<?php if ( $type_field['type'] === 'number' ) : ?>
																		<input type="number"
																			id="vimeify_setting_<?php echo esc_attr( $type_id ); ?>_<?php echo esc_attr( $field_id ); ?>"
																			name="vimeify_gallery_settings[<?php echo esc_attr( $field_id ); ?>]"
																			value="<?php echo esc_attr( $field_value ); ?>"
																			<?php if ( isset( $type_field['max'] ) ) : ?>max="<?php echo esc_attr( $type_field['max'] ); ?>"<?php endif; ?>
																			<?php if ( isset( $type_field['min'] ) ) : ?>min="<?php echo esc_attr( $type_field['min'] ); ?>"<?php endif; ?>
																			class="small-text">

																	<?php elseif ( $type_field['type'] === 'select' ) : ?>
																		<select id="vimeify_setting_<?php echo esc_attr( $type_id ); ?>_<?php echo esc_attr( $field_id ); ?>"
																			name="vimeify_gallery_settings[<?php echo esc_attr( $field_id ); ?>]">
																			<?php foreach ( $type_field['options'] as $option_value => $option_label ) : ?>
																				<option value="<?php echo esc_attr( $option_value ); ?>" <?php selected( $field_value, $option_value ); ?>>
																					<?php echo esc_html( $option_label ); ?>
																				</option>
																			<?php endforeach; ?>
																		</select>
																	<?php endif; ?>

																	<?php if ( ! empty( $type_field['desc'] ) ) : ?>
																		<p class="description"><?php echo esc_html( $type_field['desc'] ); ?></p>
																	<?php endif; ?>
																</td>
															</tr>
														<?php endforeach; ?>
													</tbody>
												</table>
											<?php endif; ?>
										</div>
									</div>
								</div>
							</div>
						</div>
					<?php endforeach; ?>
				</div>

				<!-- Settings Sidebar -->
				<div id="postbox-container-1" class="postbox-container">
					<div class="postbox">
						<div class="postbox-header">
							<h2><?php esc_html_e( 'Gallery Settings', 'vimeify' ); ?></h2>
						</div>
						<div class="inside">
							<?php
							// Group fields by which type/style they belong to
							$fields_by_type = [];
							$fields_by_style = [];

							foreach ( $gallery_types as $type_id => $type_config ) {
								if ( ! empty( $type_config['settings'] ) ) {
									foreach ( $type_config['settings'] as $type_field ) {
										$fields_by_type[ $type_id ][] = $type_field['id'];
									}
								}
							}

							foreach ( $display_styles as $style_id => $style_config ) {
								if ( ! empty( $style_config['settings'] ) ) {
									foreach ( $style_config['settings'] as $style_field ) {
										$fields_by_style[ $style_id ][] = $style_field['id'];
									}
								}
							}
							?>

							<?php foreach ( $settings_fields as $field ) : ?>
								<?php
								$field_id = $field['id'];
								$field_value = isset( $gallery_settings[ $field_id ] ) ? $gallery_settings[ $field_id ] : ( $field['default'] ?? '' );

								// Determine which type this field belongs to
								$field_type = null;
								foreach ( $fields_by_type as $type_id => $field_ids ) {
									if ( in_array( $field_id, $field_ids ) ) {
										$field_type = $type_id;
										break;
									}
								}

								// Skip type-specific fields (they're shown in the type boxes now)
								if ( $field_type ) {
									continue;
								}

								// Determine which style this field belongs to
								$field_style = null;
								foreach ( $fields_by_style as $style_id => $field_ids ) {
									if ( in_array( $field_id, $field_ids ) ) {
										$field_style = $style_id;
										break;
									}
								}

								$field_class = 'vimeify-setting-field';
								if ( $field_style ) {
									$field_class .= ' vimeify-style-specific-setting';
								}
								?>
								<div class="<?php echo esc_attr( $field_class ); ?>"
									<?php if ( $field_style ) : ?>data-style="<?php echo esc_attr( $field_style ); ?>"<?php endif; ?>
									style="margin-bottom: 15px;">
									<label for="vimeify_setting_<?php echo esc_attr( $field_id ); ?>" style="display: block; margin-bottom: 5px; font-weight: 600;">
										<?php echo esc_html( $field['label'] ); ?>
									</label>

									<?php if ( $field['type'] === 'text' ) : ?>
										<input type="text"
											id="vimeify_setting_<?php echo esc_attr( $field_id ); ?>"
											name="vimeify_gallery_settings[<?php echo esc_attr( $field_id ); ?>]"
											value="<?php echo esc_attr( $field_value ); ?>"
											class="widefat">

									<?php elseif ( $field['type'] === 'number' ) : ?>
										<input type="number"
											id="vimeify_setting_<?php echo esc_attr( $field_id ); ?>"
											name="vimeify_gallery_settings[<?php echo esc_attr( $field_id ); ?>]"
											value="<?php echo esc_attr( $field_value ); ?>"
											<?php if ( isset( $field['max'] ) ) : ?>max="<?php echo esc_attr( $field['max'] ); ?>"<?php endif; ?>
											<?php if ( isset( $field['min'] ) ) : ?>min="<?php echo esc_attr( $field['min'] ); ?>"<?php endif; ?>
											class="widefat">

									<?php elseif ( $field['type'] === 'checkbox' ) : ?>
										<label style="font-weight: normal;">
											<input type="checkbox"
												id="vimeify_setting_<?php echo esc_attr( $field_id ); ?>"
												name="vimeify_gallery_settings[<?php echo esc_attr( $field_id ); ?>]"
												value="1"
												<?php checked( $field_value, true ); ?>>
											<?php echo esc_html( $field['desc'] ?? '' ); ?>
										</label>

									<?php elseif ( $field['type'] === 'select' ) : ?>
										<select id="vimeify_setting_<?php echo esc_attr( $field_id ); ?>"
											name="vimeify_gallery_settings[<?php echo esc_attr( $field_id ); ?>]"
											class="widefat">
											<?php foreach ( $field['options'] as $option_value => $option_label ) : ?>
												<option value="<?php echo esc_attr( $option_value ); ?>" <?php selected( $field_value, $option_value ); ?>>
													<?php echo esc_html( $option_label ); ?>
												</option>
											<?php endforeach; ?>
										</select>

									<?php elseif ( $field['type'] === 'radio' ) : ?>
										<?php foreach ( $field['options'] as $option_value => $option_label ) : ?>
											<label style="display: block; margin-bottom: 5px; font-weight: normal;">
												<input type="radio"
													name="vimeify_gallery_settings[<?php echo esc_attr( $field_id ); ?>]"
													value="<?php echo esc_attr( $option_value ); ?>"
													<?php checked( $field_value, $option_value ); ?>>
												<?php echo esc_html( $option_label ); ?>
											</label>
										<?php endforeach; ?>
									<?php endif; ?>

									<?php if ( ! empty( $field['desc'] ) && $field['type'] !== 'checkbox' ) : ?>
										<p class="description" style="margin-top: 5px;"><?php echo esc_html( $field['desc'] ); ?></p>
									<?php endif; ?>
								</div>
							<?php endforeach; ?>

							<div style="margin-top: 20px;">
								<button type="submit" class="button button-primary button-large">
									<?php echo $is_edit ? esc_html__( 'Update Gallery', 'vimeify' ) : esc_html__( 'Create Gallery', 'vimeify' ); ?>
								</button>
							</div>
						</div>
					</div>

					<?php
					/**
					 * Action to add additional metaboxes to gallery sidebar
					 *
					 * @param int                  $gallery_id Gallery term ID
					 * @param bool                 $is_edit    Whether editing existing gallery
					 * @param \Vimeify\Core\Plugin $plugin     Plugin instance
					 */
					do_action( 'vimeify_gallery_sidebar_end', $gallery_id, $is_edit, $plugin );
					?>
				</div>
			</div>
		</div>
	</form>
</div>
