<?php

/* @var \Vimeify\Core\Plugin $plugin */

use \Vimeify\Core\Components\Vimeo;

$vimeo_access_token = get_option( '_vimeo_access_token' );

$access_token    = $plugin->system()->vimeo()->get_access_token();
$connection_type = $plugin->system()->vimeo()->get_connection_type();

?>

<div class="vimeify-auth">

    <div class="vimeify-auth-notice vimeify-hidden"></div>

    <div class="vimeify-auth-form" id="vimeify-auth-form">
        <div class="vimeify-auth-form--row">
            <p><?php esc_html_e( 'In order to use Vimeify plugin you need to connect to you Vimeo.com account.', 'vimeify' ); ?></p>
        </div>
        <div class="vimeify-auth-form--row">
            <div class="vimeify-auth-form--option">
                <label>
                    <input type="radio" value="<?php echo esc_attr( Vimeo::CONNECTION_TYPE_CUSTOM_ACCESS_TOKEN ); ?>" name="connection_type"
						<?php checked( Vimeo::CONNECTION_TYPE_CUSTOM_ACCESS_TOKEN, $connection_type ); ?>
                    />&nbsp;
					<?php esc_html_e( 'Long-lived Access Token', 'vimeify' ); ?>
                </label>
                <div class="vimeify-auth-form--option-details <?php echo esc_attr( Vimeo::CONNECTION_TYPE_CUSTOM_ACCESS_TOKEN === $connection_type ? '' : 'vimeify-hidden' ); ?>">
                    <label for="<?php echo esc_attr( Vimeo::CONNECTION_TYPE_CUSTOM_ACCESS_TOKEN ); ?>"><?php esc_html_e( 'Enter Access Token', 'vimeify' ); ?></label>
                    <div>
						<?php

						echo wp_kses(
							sprintf(
								__( 'The access token can be obtained by following few simple steps. To read more, %s.', 'vimeify' ),
								sprintf( '<a href="" target="_blank" rel="noopener noreferrer">%s</a>', __( 'click here', 'vimeify' ) )
							),
							'vimeify'
						);
						?>
                    </div>
                    <div>
                        <input type="text"
                               class="vimeify-auth-field"
                               id="access_token"
                               name="access_token"
                               value="<?php echo esc_attr( $access_token ); ?>"/>
                    </div>
                </div>
            </div>
			<?php if ( ! empty( $vimeo_access_token ) ): ?>
                <div class="viemify-auth-form--option">
                    <label>
                        <input type="radio" value="<?php echo esc_attr( Vimeo::CONNECTION_TYPE_VIMEO_PLUGIN ); ?>" name="connection_type"
							<?php checked( Vimeo::CONNECTION_TYPE_VIMEO_PLUGIN, $connection_type ); ?>
                        />&nbsp;
						<?php esc_html_e( 'Use Vimeo plugin connection', 'vimeify' ); ?>
                    </label>
                </div>
			<?php endif; ?>
        </div>
        <div class="vimeify-auth-form--row">
            <button type="submit" class="button button-primary vimeify-auth-ready">
                <span class="vimeify-loading vimeify-spin4 animate-spin"></span>
				<?php esc_html_e( 'Connect', 'vimeify' ); ?>
            </button>
        </div>
    </div>
</div>
