<?php
/**
 * Gallery Settings Metabox
 *
 * @var \Vimeify\Core\Plugin $plugin
 * @var \WP_Post $post
 * @var array $settings
 * @var array $fields
 */
?>

<div class="vimeify-gallery-settings">
	<?php foreach ( $fields as $field ) : ?>
		<?php
		$field_id = $field['id'];
		$field_name = 'vimeify_gallery_settings[' . $field_id . ']';
		$field_value = isset( $settings[ $field_id ] ) ? $settings[ $field_id ] : ( $field['default'] ?? '' );
		?>

		<div class="vimeify-setting-field vimeify-setting-<?php echo esc_attr( $field['type'] ); ?>">
			<?php if ( $field['type'] !== 'checkbox' ) : ?>
				<label for="<?php echo esc_attr( $field_id ); ?>">
					<strong><?php echo esc_html( $field['label'] ); ?></strong>
				</label>
			<?php endif; ?>

			<?php if ( $field['type'] === 'text' ) : ?>
				<input
					type="text"
					id="<?php echo esc_attr( $field_id ); ?>"
					name="<?php echo esc_attr( $field_name ); ?>"
					value="<?php echo esc_attr( $field_value ); ?>"
					class="widefat"
				/>

			<?php elseif ( $field['type'] === 'number' ) : ?>
				<input
					type="number"
					id="<?php echo esc_attr( $field_id ); ?>"
					name="<?php echo esc_attr( $field_name ); ?>"
					value="<?php echo esc_attr( $field_value ); ?>"
					class="widefat"
					min="1"
				/>

			<?php elseif ( $field['type'] === 'select' ) : ?>
				<select
					id="<?php echo esc_attr( $field_id ); ?>"
					name="<?php echo esc_attr( $field_name ); ?>"
					class="widefat"
				>
					<?php foreach ( $field['options'] as $option_value => $option_label ) : ?>
						<option value="<?php echo esc_attr( $option_value ); ?>" <?php selected( $field_value, $option_value ); ?>>
							<?php echo esc_html( $option_label ); ?>
						</option>
					<?php endforeach; ?>
				</select>

			<?php elseif ( $field['type'] === 'checkbox' ) : ?>
				<label for="<?php echo esc_attr( $field_id ); ?>">
					<input
						type="checkbox"
						id="<?php echo esc_attr( $field_id ); ?>"
						name="<?php echo esc_attr( $field_name ); ?>"
						value="1"
						<?php checked( $field_value, true ); ?>
					/>
					<strong><?php echo esc_html( $field['label'] ); ?></strong>
				</label>

			<?php elseif ( $field['type'] === 'radio' ) : ?>
				<div class="vimeify-radio-group">
					<?php foreach ( $field['options'] as $option_value => $option_label ) : ?>
						<label>
							<input
								type="radio"
								name="<?php echo esc_attr( $field_name ); ?>"
								value="<?php echo esc_attr( $option_value ); ?>"
								<?php checked( $field_value, $option_value ); ?>
							/>
							<?php echo esc_html( $option_label ); ?>
						</label>
						<br />
					<?php endforeach; ?>
				</div>

			<?php endif; ?>

			<?php if ( ! empty( $field['desc'] ) ) : ?>
				<p class="description"><?php echo esc_html( $field['desc'] ); ?></p>
			<?php endif; ?>
		</div>

	<?php endforeach; ?>
</div>

<style>
.vimeify-gallery-settings {
	padding: 10px 0;
}

.vimeify-setting-field {
	margin-bottom: 20px;
}

.vimeify-setting-field:last-child {
	margin-bottom: 0;
}

.vimeify-setting-field label {
	display: block;
	margin-bottom: 5px;
}

.vimeify-setting-checkbox label {
	display: inline-block;
	margin-bottom: 0;
}

.vimeify-setting-field input[type="text"],
.vimeify-setting-field input[type="number"],
.vimeify-setting-field select {
	margin-bottom: 5px;
}

.vimeify-setting-field .description {
	margin: 5px 0 0 0;
	font-style: italic;
	color: #666;
}

.vimeify-radio-group {
	margin-top: 5px;
}

.vimeify-radio-group label {
	display: inline-block;
	margin-bottom: 5px;
}
</style>
