"use strict";class VimeifyChunkedUploader{static defaults={url:"",paramName:"file",maxFileSize:0,maxFiles:1,acceptedFiles:"",chunkSize:2097152,parallelChunkUploads:!1,parallelUploads:1,retryChunks:!0,retryChunksLimit:3,handler:"vimeify"};static STATUS={PENDING:"pending",UPLOADING:"uploading",SUCCESS:"success",ERROR:"error",CANCELED:"canceled"};static isSlow=null;static speedTestSettings={maxTime:3e3,payloadSize:102400};constructor(element,options={}){this.element=element,this.options={...VimeifyChunkedUploader.defaults,...options},this.files=[],this.loading=0,this.events={},this.dataTransfer={},this._parseDataAttributes(),this._init()}_parseDataAttributes(){const el=this.element;this.dataTransfer={key:el.dataset.fieldKey||"",postMaxSize:parseInt(el.dataset.maxSize,10)||0,name:el.dataset.inputName||"file"},el.dataset.maxFileNumber&&(this.options.maxFiles=parseInt(el.dataset.maxFileNumber,10)),el.dataset.maxSize&&(this.options.maxFileSize=parseInt(el.dataset.maxSize,10)),el.dataset.fileChunkSize&&(this.options.chunkSize=parseInt(el.dataset.fileChunkSize,10)),el.dataset.inputName&&(this.options.paramName=el.dataset.inputName),el.dataset.extensions&&(this.options.acceptedFiles=el.dataset.extensions.split(",").map(ext=>"."+ext).join(",")),el.dataset.parallelUploads&&(this.options.parallelChunkUploads=/^true$/i.test(el.dataset.parallelUploads)),el.dataset.maxParallelUploads&&(this.options.parallelUploads=parseInt(el.dataset.maxParallelUploads,10)),el.dataset.handler&&(this.options.handler=el.dataset.handler)}_init(){this._setupDropzone(),this._bindEvents(),this._loadExistingFiles()}_setupDropzone(){if(!this.element.querySelector(".vimeify-message")){const message=document.createElement("div");message.className="vimeify-message",message.innerHTML=`\n                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">\n                    <path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"/>\n                    <polyline points="17 8 12 3 7 8"/>\n                    <line x1="12" y1="3" x2="12" y2="15"/>\n                </svg>\n                <span class="vimeify-title">${window.Vimeify_Chunked_Upload?.message_title||"Drop files here or click to upload"}</span>\n                <span class="vimeify-hint">${window.Vimeify_Chunked_Upload?.message_hint||""}</span>\n            `,this.element.insertBefore(message,this.element.firstChild)}if(!this.element.querySelector(".vimeify-previews")){const previews=document.createElement("div");previews.className="vimeify-previews",this.element.appendChild(previews)}this._createHiddenInput()}_createHiddenInput(){const existingInput=this.element.querySelector(".vimeify-hidden-input");if(existingInput)return this._hiddenInput=existingInput,void existingInput.addEventListener("change",e=>{e.target.files.length>0&&this._handleFiles(Array.from(e.target.files)),e.target.value=""});const input=document.createElement("input");input.type="file",input.className="vimeify-hidden-input",input.accept=this.options.acceptedFiles,input.style.display="none",input.addEventListener("change",e=>{e.target.files.length>0&&this._handleFiles(Array.from(e.target.files)),e.target.value=""}),this.element.appendChild(input),this._hiddenInput=input}_bindEvents(){this.element.addEventListener("click",e=>{e.target.closest(".vimeify-file-preview")||e.target.closest(".vimeify-remove")||this._hiddenInput.click()}),this.element.addEventListener("dragover",e=>{e.preventDefault(),e.stopPropagation(),this.element.classList.add("vimeify-drag-hover")}),this.element.addEventListener("dragleave",e=>{e.preventDefault(),e.stopPropagation(),this.element.classList.remove("vimeify-drag-hover")}),this.element.addEventListener("drop",e=>{e.preventDefault(),e.stopPropagation(),this.element.classList.remove("vimeify-drag-hover"),e.dataTransfer.files.length>0&&this._handleFiles(Array.from(e.dataTransfer.files))})}_loadExistingFiles(){const input=this.element.nextElementSibling;if(input&&input.value)try{const existingFiles=JSON.parse(input.value);for(const fileData of existingFiles){const mockFile={name:fileData.file_user_name,size:fileData.size,server_file:fileData.file,nativeFile:null,uuid:this._generateUUID(),accepted:!0,status:VimeifyChunkedUploader.STATUS.SUCCESS,previewElement:null,upload:{chunked:!0,chunks:[],totalChunkCount:0,bytesSent:fileData.size},chunkResponse:JSON.stringify({data:fileData}),retries:0};this._createPreviewElement(mockFile),this.files.push(mockFile)}this._toggleMessage()}catch(e){}}_handleFiles(nativeFiles){for(const nativeFile of nativeFiles){if(this.files.filter(f=>f.accepted).length>=this.options.maxFiles){this._showError(null,this._getErrorMessage("file_limit"));continue}const file=this._createFileObject(nativeFile);this._validateFile(file)&&(this.files.push(file),this._createPreviewElement(file),this.emit("addedfile",file),this.loading++,this._toggleSubmit(),file.size>=this.dataTransfer.postMaxSize?this._handleFileTooLarge(file):this._speedTest(()=>{this._initFileUpload(file)}))}this._toggleMessage()}_createFileObject(nativeFile){return{name:nativeFile.name,size:nativeFile.size,type:nativeFile.type,nativeFile:nativeFile,uuid:this._generateUUID(),accepted:!0,status:VimeifyChunkedUploader.STATUS.PENDING,previewElement:null,upload:{chunked:!0,chunks:[],totalChunkCount:Math.ceil(nativeFile.size/this.options.chunkSize),bytesSent:0},chunkResponse:null,retries:0,isErrorNotUploadedDisplayed:!1}}_validateFile(file){if(this.options.acceptedFiles){const extensions=this.options.acceptedFiles.split(",").map(e=>e.trim().toLowerCase()),fileExt="."+file.name.split(".").pop().toLowerCase();if(!extensions.includes(fileExt))return this._showError(file,this._getErrorMessage("file_extension")),!1}return!(this.options.maxFileSize&&file.size>this.options.maxFileSize)||(this._showError(file,this._getErrorMessage("file_size")),!1)}_handleFileTooLarge(file){file.accepted=!1,file.status=VimeifyChunkedUploader.STATUS.ERROR;const errorMessage=this._getErrorMessage("file_not_uploaded")+" "+this._getErrorMessage("post_max_size");this._addErrorToPreview(file,errorMessage),file.isErrorNotUploadedDisplayed=!0,this.loading--,this._toggleSubmit()}_createPreviewElement(file){const preview=document.createElement("div");preview.className="vimeify-file-preview",file.status===VimeifyChunkedUploader.STATUS.SUCCESS&&preview.classList.add("vimeify-complete"),preview.innerHTML=`\n            <div class="vimeify-file-image"></div>\n            <div class="vimeify-file-details">\n                <div class="vimeify-filename">${this._escapeHtml(file.name)}</div>\n                <div class="vimeify-filesize">${this._formatFileSize(file.size)}</div>\n            </div>\n            <div class="vimeify-progress">\n                <div class="vimeify-progress-bar" style="width: 0%"></div>\n            </div>\n            <div class="vimeify-error-message"></div>\n            <a href="javascript:void(0)" class="vimeify-remove" title="Remove file"></a>\n        `;preview.querySelector(".vimeify-remove").addEventListener("click",e=>{e.preventDefault(),e.stopPropagation(),this.removeFile(file)}),file.previewElement=preview;this.element.querySelector(".vimeify-previews").appendChild(preview)}_speedTest(callback){if(null!==VimeifyChunkedUploader.isSlow)return void setTimeout(callback,0);const payload=this._generatePayload(VimeifyChunkedUploader.speedTestSettings.payloadSize),startTime=Date.now();this._ajaxPost({action:this._prefixEndpoint("file_upload_speed_test"),data:payload}).then(()=>{const elapsed=Date.now()-startTime;VimeifyChunkedUploader.isSlow=elapsed>=VimeifyChunkedUploader.speedTestSettings.maxTime,callback()}).catch(()=>{VimeifyChunkedUploader.isSlow=!0,callback()})}_generatePayload(size){let data="";for(let i=0;i<size;i++)data+=String.fromCharCode(Math.round(36*Math.random()+64));return data}_initFileUpload(file){const requestData={action:this._prefixEndpoint("upload_chunk_init"),key:this.dataTransfer.key,name:file.name,slow:VimeifyChunkedUploader.isSlow,dzuuid:file.uuid,dztotalfilesize:file.size};this._ajaxPost(requestData).then(response=>{response.dzchunksize&&(this.options.chunkSize=parseInt(response.dzchunksize,10),file.upload.totalChunkCount=Math.ceil(file.size/this.options.chunkSize)),response.hasOwnProperty("parallelChunkUploads")&&(this.options.parallelChunkUploads=response.parallelChunkUploads),this._startChunkedUpload(file)}).catch(error=>{file.status=VimeifyChunkedUploader.STATUS.ERROR;const errorMessage=this._extractErrorMessage(error);this._addErrorToPreview(file,errorMessage),this.emit("error",file,errorMessage),this.loading--,this._toggleSubmit()})}_startChunkedUpload(file){file.status=VimeifyChunkedUploader.STATUS.UPLOADING,file.previewElement.classList.add("vimeify-processing");const chunkCount=file.upload.totalChunkCount;file.upload.chunks=[];for(let i=0;i<chunkCount;i++){const start=i*this.options.chunkSize,end=Math.min(start+this.options.chunkSize,file.size);file.upload.chunks.push({index:i,start:start,end:end,size:end-start,status:VimeifyChunkedUploader.STATUS.PENDING,bytesSent:0,xhr:null,retries:0})}this._uploadNextChunks(file)}_uploadNextChunks(file){if(file.status===VimeifyChunkedUploader.STATUS.ERROR||file.status===VimeifyChunkedUploader.STATUS.CANCELED)return;const pendingChunks=file.upload.chunks.filter(c=>c.status===VimeifyChunkedUploader.STATUS.PENDING),uploadingChunks=file.upload.chunks.filter(c=>c.status===VimeifyChunkedUploader.STATUS.UPLOADING);if(0===pendingChunks.length&&0===uploadingChunks.length)return void this._finalizeUpload(file);const availableSlots=(this.options.parallelChunkUploads?this.options.parallelUploads:1)-uploadingChunks.length;for(let i=0;i<Math.min(availableSlots,pendingChunks.length);i++)this._uploadChunk(file,pendingChunks[i])}_uploadChunk(file,chunk){chunk.status=VimeifyChunkedUploader.STATUS.UPLOADING;const blob=file.nativeFile.slice(chunk.start,chunk.end),formData=new FormData;formData.append(this.options.paramName,blob,file.name),formData.append("action",this._prefixEndpoint("upload_chunk")),formData.append("key",this.dataTransfer.key),formData.append("dzuuid",file.uuid),formData.append("dzchunkindex",chunk.index),formData.append("dztotalfilesize",file.size),formData.append("dzchunksize",this.options.chunkSize),formData.append("dztotalchunkcount",file.upload.totalChunkCount),formData.append("dzchunkbyteoffset",chunk.start);const xhr=new XMLHttpRequest;chunk.xhr=xhr,xhr.open("POST",window.Vimeify_Chunked_Upload.url,!0),xhr.setRequestHeader("X-Requested-With","XMLHttpRequest"),xhr.upload.addEventListener("progress",e=>{e.lengthComputable&&(chunk.bytesSent=e.loaded,this._updateProgress(file))}),xhr.addEventListener("load",()=>{xhr.status>=200&&xhr.status<300?(chunk.status=VimeifyChunkedUploader.STATUS.SUCCESS,chunk.bytesSent=chunk.size,this._updateProgress(file),this._uploadNextChunks(file)):this._handleChunkError(file,chunk,xhr.responseText)}),xhr.addEventListener("error",()=>{this._handleChunkError(file,chunk,"Network error")}),xhr.addEventListener("abort",()=>{chunk.status=VimeifyChunkedUploader.STATUS.CANCELED}),this.emit("sending",file,xhr,formData),xhr.send(formData)}_handleChunkError(file,chunk,errorMessage){if(chunk.retries++,this.options.retryChunks&&chunk.retries<this.options.retryChunksLimit)chunk.status=VimeifyChunkedUploader.STATUS.PENDING,chunk.bytesSent=0,setTimeout(()=>{this._uploadNextChunks(file)},1e3*chunk.retries);else{let displayError;if(chunk.status=VimeifyChunkedUploader.STATUS.ERROR,file.status=VimeifyChunkedUploader.STATUS.ERROR,file.previewElement.classList.add("vimeify-error"),file.previewElement.classList.remove("vimeify-processing"),errorMessage)try{const parsed=JSON.parse(errorMessage);displayError=this._extractErrorMessage(parsed)}catch(e){displayError="string"==typeof errorMessage?errorMessage:this._getErrorMessage("file_not_uploaded")}else displayError=this._getErrorMessage("file_not_uploaded");this._addErrorToPreview(file,displayError),file.isErrorNotUploadedDisplayed=!0,this.emit("error",file,displayError),this.loading--,this._toggleSubmit()}}_updateProgress(file){const totalSent=file.upload.chunks.reduce((sum,chunk)=>chunk.status===VimeifyChunkedUploader.STATUS.SUCCESS?sum+chunk.size:sum+(chunk.bytesSent||0),0),progress=Math.min(99.9,totalSent/file.size*100);file.upload.bytesSent=totalSent;const progressBar=file.previewElement.querySelector(".vimeify-progress-bar");progressBar&&(progressBar.style.width=progress+"%"),this.emit("uploadprogress",file,progress,totalSent)}_finalizeUpload(file){const requestData={action:this._prefixEndpoint("file_chunks_uploaded"),key:this.dataTransfer.key,name:file.name,dzuuid:file.uuid,dztotalfilesize:file.size};this._ajaxPost(requestData).then(response=>{file.chunkResponse=JSON.stringify({data:response}),file.status=VimeifyChunkedUploader.STATUS.SUCCESS,file.previewElement.classList.remove("vimeify-processing"),file.previewElement.classList.add("vimeify-complete");const progressBar=file.previewElement.querySelector(".vimeify-progress-bar");progressBar&&(progressBar.style.width="100%"),this.loading--,this._toggleSubmit(),this._updateInputValue(),this.emit("chunksUploaded",file,()=>{}),this.emit("complete",file)}).catch(error=>{if(file.retries++,file.retries<3)setTimeout(()=>{this._finalizeUpload(file)},5e3*file.retries);else{file.status=VimeifyChunkedUploader.STATUS.ERROR,file.previewElement.classList.add("vimeify-error"),file.previewElement.classList.remove("vimeify-processing");const displayError=this._extractErrorMessage(error);this._addErrorToPreview(file,displayError),file.isErrorNotUploadedDisplayed=!0,this.emit("error",file,displayError),this.loading--,this._toggleSubmit()}})}removeFile(file){if(file.upload.chunks)for(const chunk of file.upload.chunks)chunk.xhr&&chunk.xhr.abort();const responseJson=file.chunkResponse||(file.xhr?file.xhr.responseText:null);if(responseJson)try{const response="string"==typeof responseJson?JSON.parse(responseJson):responseJson;response?.data?.file&&this._removeFromServer(response.data.file)}catch(e){}else file.server_file&&this._removeFromServer(file.server_file);file.previewElement&&file.previewElement.remove();const index=this.files.indexOf(file);index>-1&&this.files.splice(index,1),file.status!==VimeifyChunkedUploader.STATUS.PENDING&&file.status!==VimeifyChunkedUploader.STATUS.UPLOADING||(this.loading--,this._toggleSubmit()),this._updateInputValue(),this._toggleMessage(),this.emit("removedfile",file)}_removeFromServer(filename){this._ajaxPost({action:this._prefixEndpoint("remove_file"),file:filename,key:this.dataTransfer.key}).catch(()=>{})}_updateInputValue(){const wrapper=this.element.closest(".vimeify-chunked-uploader-wrapper");if(!wrapper)return;const input=wrapper.querySelector("input[name="+this.dataTransfer.name+"]");if(!input)return;const values=this.files.filter(f=>f.status===VimeifyChunkedUploader.STATUS.SUCCESS).map(f=>{try{const response="string"==typeof f.chunkResponse?JSON.parse(f.chunkResponse):f.chunkResponse;return response?.data}catch(e){return null}}).filter(v=>v);input.value=values.length?JSON.stringify(values):"";const event=new Event("input",{bubbles:!0});input.dispatchEvent(event),window.jQuery?.fn?.valid&&window.jQuery(input).valid()}_toggleMessage(){const message=this.element.querySelector(".vimeify-message");if(!message)return;this.files.filter(f=>f.accepted).length>=this.options.maxFiles?message.classList.add("hide"):message.classList.remove("hide")}_toggleSubmit(){const form=this.element.closest("form");if(!form)return;let btn=form.querySelector("input[type=submit]")||form.querySelector("button[type=submit]");if(!btn)return;this.loading<0&&(this.loading=0);if(this.loading>0){if(btn.disabled=!0,!form.querySelector(".vimeify-submit-overlay")){const parent=btn.parentElement;parent.classList.add("vimeify-submit-overlay-container");const overlay=document.createElement("div");overlay.className="vimeify-submit-overlay",overlay.style.width=btn.offsetWidth+"px",overlay.style.height=parent.offsetHeight+"px",overlay.addEventListener("click",()=>this._showLoadingMessage(form)),parent.appendChild(overlay)}}else{btn.disabled=!1;const overlay=form.querySelector(".vimeify-submit-overlay");overlay&&overlay.remove();const parent=btn.parentElement;parent&&parent.classList.remove("vimeify-submit-overlay-container");const alert=form.querySelector(".vimeify-uploading-in-progress-alert");alert&&alert.remove()}}_showLoadingMessage(form){if(!form.querySelector(".vimeify-uploading-in-progress-alert")){const submitContainer=form.querySelector(".vimeify-submit-container");if(submitContainer){const alertDiv=document.createElement("div");alertDiv.className="vimeify-error-alert vimeify-uploading-in-progress-alert",alertDiv.textContent=window.Vimeify_Chunked_Upload?.loading_message||"File upload is in progress. Please wait...",submitContainer.parentNode.insertBefore(alertDiv,submitContainer)}}}_addErrorToPreview(file,message){if(!file.previewElement)return;file.previewElement.classList.add("vimeify-error");const errorContainer=file.previewElement.querySelector(".vimeify-error-message");if(errorContainer){const span=document.createElement("span");span.textContent=message,errorContainer.appendChild(span)}}_showError(file,message){file&&(file.accepted=!1,file.status=VimeifyChunkedUploader.STATUS.ERROR,this._createPreviewElement(file),this._addErrorToPreview(file,message),this.files.push(file)),this.emit("error",file,message)}_extractErrorMessage(error){if("string"==typeof error)return error;if(error){if("string"==typeof error.data)return error.data;if(error.data&&"string"==typeof error.data.message)return error.data.message;if(Array.isArray(error.data)&&error.data[0]?.message)return error.data[0].message;if("string"==typeof error.message)return error.message;if(error.responseJSON?.data){if("string"==typeof error.responseJSON.data)return error.responseJSON.data;if("string"==typeof error.responseJSON.data.message)return error.responseJSON.data.message}}return this._getErrorMessage("file_not_uploaded")}_getErrorMessage(key){let message=window.Vimeify_Chunked_Upload?.errors?.[key]||{file_not_uploaded:"This file was not uploaded.",file_limit:"File limit has been reached.",file_extension:"File type is not allowed.",file_size:"File exceeds the max size allowed.",post_max_size:"File exceeds the upload limit allowed."}[key]||key;return"file_limit"===key&&(message=message.replace("{fileLimit}",this.options.maxFiles)),message}_prefixEndpoint(action){return this.options.handler+"_"+action}_ajaxPost(data){return new Promise((resolve,reject)=>{const xhr=new XMLHttpRequest,formData=new FormData;for(const key in data)data.hasOwnProperty(key)&&formData.append(key,data[key]);xhr.open("POST",window.Vimeify_Chunked_Upload.url,!0),xhr.setRequestHeader("X-Requested-With","XMLHttpRequest"),xhr.onload=()=>{if(xhr.status>=200&&xhr.status<300)try{const response=JSON.parse(xhr.responseText);response.success?resolve(response.data):reject(response)}catch(e){reject({responseJSON:{success:!1,data:xhr.responseText},responseText:xhr.responseText})}else reject({responseJSON:null,responseText:xhr.responseText,status:xhr.status})},xhr.onerror=()=>{reject({responseJSON:null,responseText:xhr.responseText,status:xhr.status})},xhr.send(formData)})}_generateUUID(){return"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,c=>{const r=16*Math.random()|0;return("x"===c?r:3&r|8).toString(16)})}_formatFileSize(bytes){if(0===bytes)return"0 Bytes";const i=Math.floor(Math.log(bytes)/Math.log(1024));return parseFloat((bytes/Math.pow(1024,i)).toFixed(2))+" "+["Bytes","KB","MB","GB"][i]}_escapeHtml(str){const div=document.createElement("div");return div.textContent=str,div.innerHTML}on(event,callback){return this.events[event]||(this.events[event]=[]),this.events[event].push(callback),this}emit(event,...args){if(this.events[event])for(const callback of this.events[event])callback.apply(this,args)}processQueue(){}}!function(){function ready(){window.vimeify_chunked_upload_fields=window.vimeify_chunked_upload_fields||{};const elements=document.querySelectorAll(".vimeify-chunked-uploader"),uploaders=[];elements.forEach(el=>{const uploader=new VimeifyChunkedUploader(el);uploaders.push(uploader)}),window.vimeify_chunked_upload_fields.uploaders=uploaders}"loading"===document.readyState?document.addEventListener("DOMContentLoaded",ready):ready(),window.VimeifyChunkedUploader=VimeifyChunkedUploader,window.vimeifyChunkedFileUpload={init:ready}}();