!function(){"use strict";window.VimeifySettings=function(config){this.config=config||{},this.container=null,this.values=config.values||{},this.sections=config.sections||[],this.settings=config.settings||[],this.activeTab=null,this.saveTimeout=null,this.isDirty=!1,this.init()},VimeifySettings.prototype={init:function(){this.container=document.getElementById("vimeify-settings-root"),this.container&&(this.render(),this.bindEvents())},render:function(){var html='<div class="vimeify-settings">';if(this.sections.length>0){html+='<div class="vimeify-settings-sidebar">',html+='<div class="vimeify-settings-tabs">';for(var i=0;i<this.sections.length;i++){var section=this.sections[i];html+='<button type="button" class="vimeify-settings-tab'+(0===i?" vimeify-settings-tab--active":"")+'" data-section="'+this.escapeHtml(section.id)+'">',html+=this.escapeHtml(section.title),html+="</button>"}html+="</div>",html+="</div>"}html+='<div class="vimeify-settings-main">',html+='<form id="vimeify-settings-form" class="vimeify-settings-form">';for(var j=0;j<this.sections.length;j++){var sectionData=this.sections[j];html+='<div class="'+(0===j?"vimeify-settings-section vimeify-settings-section--active":"vimeify-settings-section")+'" data-section="'+this.escapeHtml(sectionData.id)+'">';for(var sectionFields=this.getFieldsForSection(sectionData.id),k=0;k<sectionFields.length;k++)html+=this.renderField(sectionFields[k]);html+="</div>"}if(this.config.showButtons&&(html+='<div class="vimeify-settings-footer">',html+='<button type="submit" class="button button-primary vimeify-settings-save">',html+=this.escapeHtml(this.config.buttonText||"Save changes"),html+="</button>",html+='<span class="vimeify-settings-status"></span>',this.config.documentationUrl&&(html+='<a href="'+this.escapeHtml(this.config.documentationUrl)+'" target="_blank" rel="noopener noreferrer" class="vimeify-settings-docs-link">',html+=this.escapeHtml(this.config.i18n.documentation||"Documentation"),html+="</a>"),html+="</div>"),html+="</form>",html+="</div>",html+="</div>",this.container.innerHTML=html,this.sections.length>0){var savedTab=this.getSavedTab();savedTab&&this.sectionExists(savedTab)?(this.activeTab=savedTab,this.switchTab(savedTab)):this.activeTab=this.sections[0].id}this.initAjaxSelects()},getFieldsForSection:function(sectionId){for(var fields=[],i=0;i<this.settings.length;i++){var setting=this.settings[i];setting.section===sectionId&&fields.push(setting)}return fields},renderField:function(field){var html="";switch(field.type||"text"){case"tab":html=this.renderTabField(field);break;case"checkbox":html=this.renderCheckboxField(field);break;case"radio":html=this.renderRadioField(field);break;case"select":html=this.renderSelectField(field);break;case"text":default:html=this.renderTextField(field);break;case"html":html=this.renderHtmlField(field)}return html},renderTabField:function(field){return""},renderCheckboxField:function(field){var html='<div class="vimeify-settings-field vimeify-settings-field--checkbox" data-field-id="'+this.escapeHtml(field.id)+'">';if(field.label&&(html+='<div class="vimeify-settings-field__label">'+this.escapeHtml(field.label)+"</div>"),field.desc&&(html+='<p class="vimeify-settings-field__desc">'+this.escapeHtml(field.desc)+"</p>"),field.choices){html+='<div class="vimeify-settings-field__choices">';for(var choices=field.choices,isArray=Array.isArray(choices),keys=isArray?choices:Object.keys(choices),i=0;i<keys.length;i++){var choice,choiceKey,choiceLabel,choiceValue,choiceDesc;isArray?(choiceKey=void 0!==(choice=keys[i]).value?choice.value:i,choiceLabel=choice.label||"",choiceValue=void 0!==choice.value?choice.value:1,choiceDesc=choice.desc||""):(choiceLabel=(choice=choices[choiceKey=keys[i]]).label||"",choiceValue=void 0!==choice.value?choice.value:1,choiceDesc=choice.desc||"");var inputName=this.getFieldName(field,choiceKey),checked=this.getFieldValue(field,choiceKey)?" checked":"";html+='<label class="vimeify-settings-checkbox">',html+='<input type="checkbox" name="'+this.escapeHtml(inputName)+'" value="'+this.escapeHtml(choiceValue)+'"'+checked+">",html+='<span class="vimeify-settings-checkbox__label">'+this.escapeHtml(choiceLabel)+"</span>",choiceDesc&&(html+='<span class="vimeify-settings-checkbox__desc">'+this.escapeHtml(choiceDesc)+"</span>"),html+="</label>"}html+="</div>"}return html+="</div>"},renderRadioField:function(field){var html='<div class="vimeify-settings-field vimeify-settings-field--radio" data-field-id="'+this.escapeHtml(field.id)+'">';if(field.label&&(html+='<div class="vimeify-settings-field__label">'+this.escapeHtml(field.label)+"</div>"),field.desc&&(html+='<p class="vimeify-settings-field__desc">'+this.escapeHtml(field.desc)+"</p>"),field.choices){html+='<div class="vimeify-settings-field__choices">';for(var currentValue=this.getFieldValue(field),defaultValue=field.std||"",i=0;i<field.choices.length;i++){var choice=field.choices[i],choiceValue=void 0!==choice.value?choice.value:"",checked="";null!=currentValue&&""!==currentValue?checked=currentValue===choiceValue?" checked":"":defaultValue===choiceValue&&(checked=" checked");var inputName=this.getFieldName(field);html+='<label class="vimeify-settings-radio">',html+='<input type="radio" name="'+this.escapeHtml(inputName)+'" value="'+this.escapeHtml(choiceValue)+'"'+checked+">",html+='<span class="vimeify-settings-radio__label">'+this.escapeHtml(choice.label||"")+"</span>",html+="</label>"}html+="</div>"}return html+="</div>"},renderSelectField:function(field){var isAjax=field.ajax&&field.ajax.action,html='<div class="vimeify-settings-field vimeify-settings-field--select'+(isAjax?" vimeify-settings-field--ajax":"")+'" data-field-id="'+this.escapeHtml(field.id)+'">';field.label&&(html+='<div class="vimeify-settings-field__label">'+this.escapeHtml(field.label)+"</div>"),field.desc&&(html+='<p class="vimeify-settings-field__desc">'+this.escapeHtml(field.desc)+"</p>");var inputName=this.getFieldName(field),currentValue=this.getFieldValue(field),placeholder=field.placeholder||"";if(isAjax){if(html+='<select class="vimeify-settings-select vimeify-ajax-select" name="'+this.escapeHtml(inputName)+'"',html+=' data-ajax-endpoint="'+this.escapeHtml(field.ajax.endpoint||"")+'"',html+=' data-ajax-action="'+this.escapeHtml(field.ajax.action||"")+'"',html+=' data-ajax-nonce="'+this.escapeHtml(field.ajax.nonce||"")+'"',html+=' data-placeholder="'+this.escapeHtml(placeholder)+'"',html+=">",field.choices&&field.choices.length>0)for(var i=0;i<field.choices.length;i++){var choice=field.choices[i],selected=currentValue==choice.value?" selected":"";html+='<option value="'+this.escapeHtml(choice.value||"")+'"'+selected+">",html+=this.escapeHtml(choice.label||""),html+="</option>"}html+="</select>"}else{if(html+='<select class="vimeify-settings-select" name="'+this.escapeHtml(inputName)+'">',placeholder&&(html+='<option value="">'+this.escapeHtml(placeholder)+"</option>"),field.choices)for(var choices=field.choices,choicesArray=Array.isArray(choices)?choices:Object.values(choices),j=0;j<choicesArray.length;j++){var opt=choicesArray[j],optValue=void 0!==opt.value?opt.value:"",optLabel=opt.label||"",optDisabled=opt.disabled?" disabled":"",optSelected=currentValue==optValue?" selected":"";html+='<option value="'+this.escapeHtml(optValue)+'"'+optDisabled+optSelected+">",html+=this.escapeHtml(optLabel),html+="</option>"}html+="</select>"}return html+="</div>"},renderTextField:function(field){var html='<div class="vimeify-settings-field vimeify-settings-field--text" data-field-id="'+this.escapeHtml(field.id)+'">';field.label&&(html+='<div class="vimeify-settings-field__label">'+this.escapeHtml(field.label)+"</div>"),field.desc&&(html+='<p class="vimeify-settings-field__desc">'+this.escapeHtml(field.desc)+"</p>");var inputName=this.getFieldName(field),currentValue=this.getFieldValue(field),placeholder=field.placeholder||"";return html+='<input type="text" class="vimeify-settings-input regular-text" name="'+this.escapeHtml(inputName)+'"',html+=' value="'+this.escapeHtml(currentValue||"")+'"',placeholder&&(html+=' placeholder="'+this.escapeHtml(placeholder)+'"'),html+=">",html+="</div>"},renderHtmlField:function(field){var html='<div class="vimeify-settings-field vimeify-settings-field--html" data-field-id="'+this.escapeHtml(field.id)+'">';return field.label&&(html+='<div class="vimeify-settings-field__label">'+this.escapeHtml(field.label)+"</div>"),field.markup&&(html+='<div class="vimeify-settings-field__markup">'+field.markup+"</div>"),html+="</div>"},getFieldName:function(field,choiceKey){var section=field.section||"",fieldId=field.id||"";return void 0!==choiceKey?section+"["+fieldId+"]["+choiceKey+"]":section+"["+fieldId+"]"},getFieldValue:function(field,choiceKey){var section=field.section||"",fieldId=field.id||"";return this.values&&this.values[section]&&void 0!==this.values[section][fieldId]?void 0!==choiceKey?this.values[section][fieldId][choiceKey]||"":this.values[section][fieldId]:field.std||""},initAjaxSelects:function(){var self=this;this.container.querySelectorAll(".vimeify-ajax-select").forEach(function(select){self.initSingleAjaxSelect(select)})},initSingleAjaxSelect:function(select){var self=this,endpoint=select.dataset.ajaxEndpoint,action=select.dataset.ajaxAction,nonce=select.dataset.ajaxNonce,placeholder=select.dataset.placeholder||"";"undefined"!=typeof jQuery&&jQuery.fn.select2&&jQuery(select).select2({width:"100%",placeholder:placeholder,allowClear:!0,minimumInputLength:0,ajax:{url:endpoint+"?action="+action+"&_wpnonce="+nonce,dataType:"json",delay:250,data:function(params){return{search_str:params.term||"",page_number:params.page||1}},processResults:function(response,params){return params.page=params.page||1,response.success&&response.data.results?{results:response.data.results,pagination:response.data.pagination||{}}:{results:[]}},cache:!0},language:{errorLoading:function(){return self.config.i18n.error||"Error loading results"},noResults:function(){return self.config.i18n.noResults||"No results found"},searching:function(){return self.config.i18n.searching||"Searching..."},inputTooShort:function(){return self.config.i18n.typeToSearch||"Type to search..."}}})},bindEvents:function(){var self=this;this.container.querySelectorAll(".vimeify-settings-tab").forEach(function(tab){tab.addEventListener("click",function(e){e.preventDefault(),self.switchTab(this.dataset.section)})});var form=document.getElementById("vimeify-settings-form");form&&form.addEventListener("submit",function(e){e.preventDefault(),self.saveSettings()}),this.container.querySelectorAll("input, select, textarea").forEach(function(input){input.addEventListener("change",function(){self.isDirty=!0})})},switchTab:function(sectionId){this.container.querySelectorAll(".vimeify-settings-tab").forEach(function(tab){tab.dataset.section===sectionId?tab.classList.add("vimeify-settings-tab--active"):tab.classList.remove("vimeify-settings-tab--active")}),this.container.querySelectorAll(".vimeify-settings-section").forEach(function(section){section.dataset.section===sectionId?section.classList.add("vimeify-settings-section--active"):section.classList.remove("vimeify-settings-section--active")}),this.activeTab=sectionId,this.saveTab(sectionId)},sectionExists:function(sectionId){for(var i=0;i<this.sections.length;i++)if(this.sections[i].id===sectionId)return!0;return!1},getSavedTab:function(){try{return localStorage.getItem("vimeify_settings_active_tab")}catch(e){return null}},saveTab:function(tabId){try{localStorage.setItem("vimeify_settings_active_tab",tabId)}catch(e){}},saveSettings:function(){var self=this,form=document.getElementById("vimeify-settings-form"),saveBtn=this.container.querySelector(".vimeify-settings-save"),statusEl=this.container.querySelector(".vimeify-settings-status");if(form){saveBtn&&(saveBtn.disabled=!0,saveBtn.textContent=this.config.i18n.saving||"Saving...");var formData=new FormData(form);formData.append("action",this.config.saveAction||"vimeify_save_settings"),formData.append("_wpnonce",this.config.nonce);var xhr=new XMLHttpRequest;xhr.open("POST",this.config.ajaxUrl,!0),xhr.onload=function(){if(200===xhr.status)try{var response=JSON.parse(xhr.responseText);response.success?(self.isDirty=!1,statusEl&&(statusEl.textContent=self.config.updatedMessage||"Options updated!",statusEl.className="vimeify-settings-status vimeify-settings-status--success"),response.data&&response.data.values&&(self.values=response.data.values)):statusEl&&(statusEl.textContent=response.data&&response.data.message||self.config.i18n.error,statusEl.className="vimeify-settings-status vimeify-settings-status--error")}catch(e){statusEl&&(statusEl.textContent=self.config.i18n.error||"Error saving settings",statusEl.className="vimeify-settings-status vimeify-settings-status--error")}else statusEl&&(statusEl.textContent=self.config.i18n.error||"Error saving settings",statusEl.className="vimeify-settings-status vimeify-settings-status--error");saveBtn&&(saveBtn.disabled=!1,saveBtn.textContent=self.config.buttonText||"Save changes"),setTimeout(function(){statusEl&&(statusEl.textContent="",statusEl.className="vimeify-settings-status")},3e3)},xhr.onerror=function(){saveBtn&&(saveBtn.disabled=!1,saveBtn.textContent=self.config.buttonText||"Save changes"),statusEl&&(statusEl.textContent=self.config.i18n.error||"Error saving settings",statusEl.className="vimeify-settings-status vimeify-settings-status--error")},xhr.send(formData)}},escapeHtml:function(text){if(null==text)return"";var div=document.createElement("div");return div.textContent=String(text),div.innerHTML}},document.addEventListener("DOMContentLoaded",function(){"undefined"!=typeof Vimeify_Settings&&document.getElementById("vimeify-settings-root")&&new VimeifySettings(Vimeify_Settings)})}();