!function(){"use strict";window.VimeifyMetabox=function(config){this.config=config||{},this.container=null,this.values=config.values||{},this.tabs=config.tabs||[],this.fields=config.fields||[],this.activeTab=null,this.metaboxId=config.metaboxId||"vimeify_metabox",this.saveMode=config.saveMode||"compact",this.init()},VimeifyMetabox.prototype={init:function(){this.container=document.getElementById("vimeify-metabox-root-"+this.metaboxId),this.container&&(this.render(),this.bindEvents())},render:function(){var html='<div class="vimeify-metabox">';if(this.tabs.length>0){html+='<div class="vimeify-metabox-sidebar">',html+='<div class="vimeify-metabox-tabs">';for(var i=0;i<this.tabs.length;i++){var tab=this.tabs[i];html+='<button type="button" class="vimeify-metabox-tab'+(0===i?" vimeify-metabox-tab--active":"")+'" data-tab="'+this.escapeHtml(tab.id)+'">',html+=this.escapeHtml(tab.label),html+="</button>"}html+="</div>",html+="</div>"}if(html+='<div class="vimeify-metabox-main">',html+='<div class="vimeify-metabox-content">',this.tabs.length>0){for(var currentTab=null,j=0;j<this.fields.length;j++){var field=this.fields[j];if("tab"===field.type)null!==currentTab&&(html+="</div>"),html+='<div class="'+(null===currentTab?"vimeify-metabox-section vimeify-metabox-section--active":"vimeify-metabox-section")+'" data-tab="'+this.escapeHtml(field.id)+'">',currentTab=field.id;else html+=this.renderField(field)}null!==currentTab&&(html+="</div>")}else for(var k=0;k<this.fields.length;k++)"tab"!==this.fields[k].type&&(html+=this.renderField(this.fields[k]));if(html+="</div>",html+="</div>",html+="</div>",this.container.innerHTML=html,this.tabs.length>0){var savedTab=this.getSavedTab();savedTab&&this.tabExists(savedTab)?(this.activeTab=savedTab,this.switchTab(savedTab)):this.activeTab=this.tabs[0].id}this.initAjaxSelects()},renderField:function(field){var html="";switch(field.type||"text"){case"checkbox":html=this.renderCheckboxField(field);break;case"radio":html=this.renderRadioField(field);break;case"select":html=this.renderSelectField(field);break;case"text":default:html=this.renderTextField(field);break;case"html":html=this.renderHtmlField(field)}return html},renderCheckboxField:function(field){var html='<div class="vimeify-metabox-field vimeify-metabox-field--checkbox" data-field-id="'+this.escapeHtml(field.id)+'">';if(field.label&&(html+='<div class="vimeify-metabox-field__label">'+this.escapeHtml(field.label)+"</div>"),field.desc&&(html+='<p class="vimeify-metabox-field__desc">'+this.escapeHtml(field.desc)+"</p>"),field.choices){html+='<div class="vimeify-metabox-field__choices">';for(var choices=field.choices,isArray=Array.isArray(choices),keys=isArray?choices:Object.keys(choices),i=0;i<keys.length;i++){var choice,choiceKey,choiceLabel,choiceValue,choiceDesc;isArray?(choiceKey=void 0!==(choice=keys[i]).value?choice.value:i,choiceLabel=choice.label||"",choiceValue=void 0!==choice.value?choice.value:1,choiceDesc=choice.desc||""):(choiceLabel=(choice=choices[choiceKey=keys[i]]).label||"",choiceValue=void 0!==choice.value?choice.value:1,choiceDesc=choice.desc||"");var checked=this.getFieldValue(field.id,choiceKey)?" checked":"";html+='<label class="vimeify-metabox-checkbox">',html+='<input type="checkbox" data-field="'+this.escapeHtml(field.id)+'" data-choice="'+this.escapeHtml(choiceKey)+'" value="'+this.escapeHtml(choiceValue)+'"'+checked+">",html+='<span class="vimeify-metabox-checkbox__label">'+this.escapeHtml(choiceLabel)+"</span>",choiceDesc&&(html+='<span class="vimeify-metabox-checkbox__desc">'+this.escapeHtml(choiceDesc)+"</span>"),html+="</label>"}html+="</div>"}return html+="</div>"},renderRadioField:function(field){var html='<div class="vimeify-metabox-field vimeify-metabox-field--radio" data-field-id="'+this.escapeHtml(field.id)+'">';if(field.label&&(html+='<div class="vimeify-metabox-field__label">'+this.escapeHtml(field.label)+"</div>"),field.desc&&(html+='<p class="vimeify-metabox-field__desc">'+this.escapeHtml(field.desc)+"</p>"),field.choices){html+='<div class="vimeify-metabox-field__choices">';for(var currentValue=this.getFieldValue(field.id),defaultValue=field.std||"",i=0;i<field.choices.length;i++){var choice=field.choices[i],choiceValue=void 0!==choice.value?choice.value:"",checked="";null!=currentValue&&""!==currentValue?checked=currentValue===choiceValue?" checked":"":defaultValue===choiceValue&&(checked=" checked"),html+='<label class="vimeify-metabox-radio">',html+='<input type="radio" name="vimeify_meta_'+this.escapeHtml(field.id)+'" data-field="'+this.escapeHtml(field.id)+'" value="'+this.escapeHtml(choiceValue)+'"'+checked+">",html+='<span class="vimeify-metabox-radio__label">'+this.escapeHtml(choice.label||"")+"</span>",html+="</label>"}html+="</div>"}return html+="</div>"},renderSelectField:function(field){var isAjax=field.ajax&&field.ajax.action,html='<div class="vimeify-metabox-field vimeify-metabox-field--select'+(isAjax?" vimeify-metabox-field--ajax":"")+'" data-field-id="'+this.escapeHtml(field.id)+'">';field.label&&(html+='<div class="vimeify-metabox-field__label">'+this.escapeHtml(field.label)+"</div>"),field.desc&&(html+='<p class="vimeify-metabox-field__desc">'+this.escapeHtml(field.desc)+"</p>");var currentValue=this.getFieldValue(field.id),placeholder=field.placeholder||"";if(isAjax){if(html+='<select class="vimeify-metabox-select vimeify-ajax-select" data-field="'+this.escapeHtml(field.id)+'"',html+=' data-ajax-endpoint="'+this.escapeHtml(field.ajax.endpoint||"")+'"',html+=' data-ajax-action="'+this.escapeHtml(field.ajax.action||"")+'"',html+=' data-ajax-nonce="'+this.escapeHtml(field.ajax.nonce||"")+'"',html+=' data-placeholder="'+this.escapeHtml(placeholder)+'"',html+=">",field.choices&&field.choices.length>0)for(var i=0;i<field.choices.length;i++){var choice=field.choices[i],selected=currentValue==choice.value?" selected":"";html+='<option value="'+this.escapeHtml(choice.value||"")+'"'+selected+">",html+=this.escapeHtml(choice.label||""),html+="</option>"}html+="</select>"}else{if(html+='<select class="vimeify-metabox-select" data-field="'+this.escapeHtml(field.id)+'">',placeholder&&(html+='<option value="">'+this.escapeHtml(placeholder)+"</option>"),field.choices)for(var choices=field.choices,choicesArray=Array.isArray(choices)?choices:Object.values(choices),j=0;j<choicesArray.length;j++){var opt=choicesArray[j],optValue=void 0!==opt.value?opt.value:"",optLabel=opt.label||"",optDisabled=opt.disabled?" disabled":"",optSelected=currentValue==optValue?" selected":"";html+='<option value="'+this.escapeHtml(optValue)+'"'+optDisabled+optSelected+">",html+=this.escapeHtml(optLabel),html+="</option>"}html+="</select>"}return html+="</div>"},renderTextField:function(field){var html='<div class="vimeify-metabox-field vimeify-metabox-field--text" data-field-id="'+this.escapeHtml(field.id)+'">';field.label&&(html+='<div class="vimeify-metabox-field__label">'+this.escapeHtml(field.label)+"</div>"),field.desc&&(html+='<p class="vimeify-metabox-field__desc">'+this.escapeHtml(field.desc)+"</p>");var currentValue=this.getFieldValue(field.id),placeholder=field.placeholder||"";return html+='<input type="text" class="vimeify-metabox-input regular-text" data-field="'+this.escapeHtml(field.id)+'"',html+=' value="'+this.escapeHtml(currentValue||"")+'"',placeholder&&(html+=' placeholder="'+this.escapeHtml(placeholder)+'"'),html+=">",html+="</div>"},renderHtmlField:function(field){var html='<div class="vimeify-metabox-field vimeify-metabox-field--html" data-field-id="'+this.escapeHtml(field.id)+'">';return field.label&&(html+='<div class="vimeify-metabox-field__label">'+this.escapeHtml(field.label)+"</div>"),field.markup&&(html+='<div class="vimeify-metabox-field__markup">'+field.markup+"</div>"),html+="</div>"},getFieldValue:function(fieldId,choiceKey){return this.values&&void 0!==this.values[fieldId]?void 0!==choiceKey?this.values[fieldId][choiceKey]||"":this.values[fieldId]:""},initAjaxSelects:function(){var self=this;this.container.querySelectorAll(".vimeify-ajax-select").forEach(function(select){self.initSingleAjaxSelect(select)})},initSingleAjaxSelect:function(select){var self=this,endpoint=select.dataset.ajaxEndpoint,action=select.dataset.ajaxAction,nonce=select.dataset.ajaxNonce,placeholder=select.dataset.placeholder||"";"undefined"!=typeof jQuery&&jQuery.fn.select2&&(jQuery(select).select2({width:"100%",placeholder:placeholder,allowClear:!0,minimumInputLength:0,ajax:{url:endpoint+"?action="+action+"&_wpnonce="+nonce,dataType:"json",delay:250,data:function(params){return{search_str:params.term||"",page_number:params.page||1}},processResults:function(response,params){return params.page=params.page||1,response.success&&response.data.results?{results:response.data.results,pagination:response.data.pagination||{}}:{results:[]}},cache:!0},language:{errorLoading:function(){return self.config.i18n.error||"Error loading results"},noResults:function(){return self.config.i18n.noResults||"No results found"},searching:function(){return self.config.i18n.searching||"Searching..."},inputTooShort:function(){return self.config.i18n.typeToSearch||"Type to search..."}}}),jQuery(select).on("change",function(){self.updateHiddenData()}))},bindEvents:function(){var self=this;this.container.querySelectorAll(".vimeify-metabox-tab").forEach(function(tab){tab.addEventListener("click",function(e){e.preventDefault(),self.switchTab(this.dataset.tab)})}),this.container.querySelectorAll("input, select, textarea").forEach(function(input){input.addEventListener("change",function(){self.updateHiddenData()})})},switchTab:function(tabId){this.container.querySelectorAll(".vimeify-metabox-tab").forEach(function(tab){tab.dataset.tab===tabId?tab.classList.add("vimeify-metabox-tab--active"):tab.classList.remove("vimeify-metabox-tab--active")}),this.container.querySelectorAll(".vimeify-metabox-section").forEach(function(section){section.dataset.tab===tabId?section.classList.add("vimeify-metabox-section--active"):section.classList.remove("vimeify-metabox-section--active")}),this.activeTab=tabId,this.saveTab(tabId)},tabExists:function(tabId){for(var i=0;i<this.tabs.length;i++)if(this.tabs[i].id===tabId)return!0;return!1},getSavedTab:function(){try{return localStorage.getItem("vimeify_metabox_"+this.metaboxId+"_active_tab")}catch(e){return null}},saveTab:function(tabId){try{localStorage.setItem("vimeify_metabox_"+this.metaboxId+"_active_tab",tabId)}catch(e){}},updateHiddenData:function(){if("compact"===this.saveMode){var data={},self=this;this.fields.forEach(function(field){if("tab"!==field.type&&"html"!==field.type){var fieldId=field.id;if("checkbox"===field.type&&field.choices){data[fieldId]={};for(var choices=field.choices,isArray=Array.isArray(choices),keys=isArray?choices:Object.keys(choices),i=0;i<keys.length;i++){var choiceKey;if(isArray){var choice=keys[i];choiceKey=void 0!==choice.value?choice.value:i}else choiceKey=keys[i];var checkbox=self.container.querySelector('input[type="checkbox"][data-field="'+fieldId+'"][data-choice="'+choiceKey+'"]');checkbox&&(data[fieldId][choiceKey]=checkbox.checked?checkbox.value:"")}}else if("radio"===field.type){var radio=self.container.querySelector('input[type="radio"][data-field="'+fieldId+'"]:checked');data[fieldId]=radio?radio.value:""}else{var input=self.container.querySelector('[data-field="'+fieldId+'"]');input&&(data[fieldId]=input.value||"")}}});var hiddenInput=document.getElementById(this.metaboxId+"_data");hiddenInput&&(hiddenInput.value=JSON.stringify(data)),this.values=data}},escapeHtml:function(text){if(null==text)return"";var div=document.createElement("div");return div.textContent=String(text),div.innerHTML}},document.addEventListener("DOMContentLoaded",function(){document.querySelectorAll(".vimeify-metabox-root").forEach(function(root){var configName="Vimeify_Metabox_"+root.dataset.metaboxId;void 0!==window[configName]&&new VimeifyMetabox(window[configName])})})}();