document.addEventListener('DOMContentLoaded', function () {
    // Conditional form
    let options = document.querySelectorAll('.vimeify-auth input[type=radio][name=connection_type]');
    for (let i = 0; i < options.length; i++) {
        options[i].addEventListener('change', function (e) {
            let allDetails = this.closest('.vimeify-auth-form--row').querySelectorAll('.vimeify-auth-form--option-details');
            for (let i = 0; i < allDetails.length; i++) {
                allDetails[i].classList.add('vimeify-hidden');
            }
            let wrapper = this.closest('.vimeify-auth-form--option');
            if (wrapper) {
                let details = wrapper.querySelector('.vimeify-auth-form--option-details');
                if (details) {
                    details.classList.remove('vimeify-hidden');
                }
            }
        })
    }

    // Save handler
    let button = document.querySelector('#vimeify-auth-form button[type=submit]');
    if (button) {
        button.addEventListener('click', async function (e) {
            e.preventDefault();

            this.disabled = true;

            this.classList.remove('vimeify-auth-ready');
            this.classList.add('disabled');

            let wrapper = this.closest('#vimeify-auth-form');
            let formData = new FormData();

            // Connection type
            let checkboxes = wrapper.querySelectorAll('input[name=connection_type]');
            let conn_type = '';
            for (let i = 0; i < checkboxes.length; i++) {
                if (checkboxes[i].checked) {
                    conn_type = checkboxes[i].value;
                    formData.append('connection_type', checkboxes[i].value);
                }
            }

            // Form Fields
            let fields = document.querySelectorAll('.vimeify-auth-field');
            for (let i = 0; i < fields.length; i++) {
                formData.append(fields[i].name, fields[i].value);
            }

            // Nonce
            formData.append('_wpnonce', Vimeify_Connect.nonce);

            // Call
            let url = Vimeify_Connect.ajax_url + '?action=vimeify_connect';
            const response = await fetch(url, {
                method: 'POST',
                body: formData,
            });

            if (response.ok) {
                const main = this.closest('.vimeify-auth')
                const notice = main.querySelector('.vimeify-auth-notice');
                const result = await response.json();
                notice.innerHTML = result?.data?.message;
                notice.classList.remove('vimeify-auth-notice--success')
                notice.classList.remove('vimeify-auth-notice--error')
                notice.classList.remove('vimeify-hidden');
                if (result?.success) {
                    notice.classList.add('vimeify-auth-notice--success');
                    setTimeout(function () {
                        window.location.reload();
                    }, 500);
                } else {
                    notice.classList.add('vimeify-auth-notice--error');
                }
            }

            this.disabled = false;
            this.classList.add('vimeify-auth-ready');
            this.classList.remove('disabled');
            //formData.append('connection_type', );

        })
    }


    // Disconnect handler
    let disconnectBtn = document.getElementById('vimeify-auth-disconnect-action');
    if (disconnectBtn) {
        disconnectBtn.addEventListener('click', async function (e) {
            e.preventDefault();

            this.disabled = true;
            this.classList.remove('vimeify-auth-ready');
            this.classList.add('disabled');

            let formData = new FormData();

            // Nonce
            formData.append('_wpnonce', Vimeify_Connect.nonce);

            //Call
            let url = Vimeify_Connect.ajax_url + '?action=vimeify_disconnect';
            const response = await fetch(url, {
                method: 'POST',
                body: formData,
            });

            if (response.ok) {
                const main = this.closest('.vimeify-auth')
                const notice = main.querySelector('.vimeify-auth-notice');
                const result = await response.json();
                notice.innerHTML = result?.data?.message;
                notice.classList.remove('vimeify-auth-notice--success')
                notice.classList.remove('vimeify-auth-notice--error')
                notice.classList.remove('vimeify-hidden');
                if (result?.success) {
                    notice.classList.add('vimeify-auth-notice--success');
                    setTimeout(function () {
                        window.location.reload();
                    }, 500);
                } else {
                    notice.classList.add('vimeify-auth-notice--error');
                }
            }

            this.disabled = false;
            this.classList.add('vimeify-auth-ready');
            this.classList.remove('disabled');

        })
    }

})