<?php
/********************************************************************
 * Copyright (C) 2024 Darko Gjorgjijoski (https://darkog.com/)
 * Copyright (C) 2024 IDEOLOGIX MEDIA Dooel (https://ideologix.com/)
 *
 * This file is property of IDEOLOGIX MEDIA Dooel (https://ideologix.com)
 * This file is part of Vimeify Plugin - https://wordpress.org/plugins/vimeify/
 *
 * Vimeify - Formerly "WP Vimeo Videos" is free software: you can redistribute
 * it and/or modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the License,
 * or (at your option) any later version.
 *
 * Vimeify - Formerly "WP Vimeo Videos" is distributed in the hope that it
 * will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this plugin. If not, see <https://www.gnu.org/licenses/>.
 *
 * Code developed by Darko Gjorgjijoski <dg@darkog.com>.
 **********************************************************************/

namespace Vimeify\Core\Wrappers;

use Vimeify\Core\Components\Vimeo;

class ConnectionState {

	public bool $is_connected = false;
	public bool $is_authenticated_connection = true;
	public string $error = '';
	public string $user_name = '';
	public string $user_uri = '';
	public string $user_link = '';
	public string $user_type = '';
	public string $app_name = '';
	public string $app_uri = '';
	public array $headers = [];
	public array $upload_quota = [];
	public array $scopes = [];
	public array $scopes_missing = [];


	public function __construct( $response = [] ) {

		// Set connection details
		if ( is_array( $response ) && isset( $response['status'] ) ) {
			$status = $response['status'];
			if ( $status === 200 ) {
				$this->is_connected = true;
				// If user object is not present assume this is unauthenticated connection.
				if ( ! isset( $response['body']['user'] ) ) {
					$this->is_authenticated_connection = false;
				} else {
					$this->is_authenticated_connection = true;
				}
			} else {
				$this->is_connected                = false;
				$this->is_authenticated_connection = false;
				if ( isset( $response['body']['developer_message'] ) ) {
					$this->error = $response['body']['developer_message'];
				}
			}
		} else {
			// Error is set in exception method.
			$this->is_connected = false;
		}

		// Set other details.
		$this->user_name    = isset( $response['body']['user']['name'] ) ? $response['body']['user']['name'] : '';
		$this->user_uri     = isset( $response['body']['user']['uri'] ) ? $response['body']['user']['uri'] : '';
		$this->user_link    = isset( $response['body']['user']['link'] ) ? $response['body']['user']['link'] : '';
		$this->user_type    = isset( $response['body']['user']['account'] ) ? $response['body']['user']['account'] : '';
		$this->app_name     = isset( $response['body']['app']['name'] ) ? $response['body']['app']['name'] : '';
		$this->app_uri      = isset( $response['body']['app']['uri'] ) ? $response['body']['app']['uri'] : '';
		$this->headers      = isset( $response['headers'] ) ? $response['headers'] : array();
		$this->upload_quota = isset( $response['body']['user']['upload_quota'] ) ? $response['body']['user']['upload_quota'] : array();
		$_scopes            = isset( $response['body']['scope'] ) ? $response['body']['scope'] : '';

		if ( ! empty( $_scopes ) ) {
			$this->scopes         = explode( ' ', $_scopes );
			$this->scopes_missing = array_diff( Vimeo::CONNECTION_REQUIRED_SCOPES, $this->scopes );
		}

	}
}