<?php
/********************************************************************
 * Copyright (C) 2024 Darko Gjorgjijoski (https://darkog.com/)
 * Copyright (C) 2024 IDEOLOGIX MEDIA Dooel (https://ideologix.com/)
 *
 * This file is property of IDEOLOGIX MEDIA Dooel (https://ideologix.com)
 * This file is part of Vimeify Plugin - https://wordpress.org/plugins/vimeify/
 *
 * Vimeify - Formerly "WP Vimeo Videos" is free software: you can redistribute
 * it and/or modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the License,
 * or (at your option) any later version.
 *
 * Vimeify - Formerly "WP Vimeo Videos" is distributed in the hope that it
 * will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this plugin. If not, see <https://www.gnu.org/licenses/>.
 *
 * Code developed by Darko Gjorgjijoski <dg@darkog.com>.
 **********************************************************************/

namespace Vimeify\Core\Utilities;

use Vimeify\Core\Abstracts\Interfaces\PluginInterface;
use Vimeify\Core\Plugin;

/**
 * Class ProcessManager
 *
 * @deprecated 2.0.0 Use UploadQueue instead for background video uploads.
 *             ProcessManager used WP_Background_Process which was unreliable.
 *             The new UploadQueue class uses Action Scheduler for better reliability.
 *
 * This class is kept for backwards compatibility with third-party extensions
 * but all internal usage has been migrated to UploadQueue.
 *
 * @see UploadQueue
 */
class ProcessManager {

	private $processes = array();

	/**
	 * List of instances
	 * @var array
	 */
	private $instances = array();

	/**
	 * The plugin instance
	 * @var Plugin
	 */
	protected $plugin = null;

	/**
	 * The class singleton instance
	 * @var ProcessManager
	 */
	private static $instance = null;

	/**
	 * ProcessManager constructor.
	 *
	 * @param Plugin $plugin
	 *
	 * @deprecated 2.0.0 Use UploadQueue::queue() instead
	 */
	private function __construct( $plugin = null ) {
		if ( ! is_null( $plugin ) ) {
			$this->plugin = $plugin;
		}
		add_action( 'plugins_loaded', array( $this, 'init' ) );
	}

	/**
	 * Init
	 *
	 * @deprecated 2.0.0
	 */
	public function init() {
		foreach ( $this->processes as $key => $process ) {
			if ( class_exists( $process ) ) {
				$this->instances[ $key ] = new $process( $this->plugin );
			}
		}
	}

	/**
	 * Returns the process
	 *
	 * @param $key
	 *
	 * @return null|\WP_Background_process|\WP_Async_Request
	 *
	 * @deprecated 2.0.0 Use UploadQueue::queue() instead for uploads
	 */
	public function get( $key ) {
		if ( isset( $this->instances[ $key ] ) ) {
			return $this->instances[ $key ];
		} else {
			return null;
		}
	}

	/**
	 * Push process
	 *
	 * @param $key
	 * @param $className
	 *
	 * @deprecated 2.0.0 Use UploadQueue::queue() instead for uploads
	 */
	public function push( $key, $className ) {
		$this->processes[ $key ] = $className;
	}

	/**
	 * Return all processes
	 *
	 * @return \WP_Background_process[]|\WP_Async_Request[]
	 *
	 * @deprecated 2.0.0
	 */
	public function all() {
		return $this->instances;
	}

	/**
	 * Set the plugin instance
	 *
	 * @param Plugin $plugin
	 *
	 * @return void
	 *
	 * @deprecated 2.0.0
	 */
	public function set_plugin( $plugin ) {
		$this->plugin = $plugin;
	}

	/**
	 * Get the instance
	 *
	 * @param Plugin|PluginInterface $plugin
	 *
	 * @return ProcessManager
	 *
	 * @deprecated 2.0.0 Use UploadQueue for background uploads instead
	 */
	public static function instance( $plugin = null ) {
		if ( self::$instance == null ) {
			self::$instance = new self( $plugin );
		}

		return self::$instance;
	}

	/**
	 * Create instance
	 *
	 * @param Plugin|PluginInterface $plugin
	 *
	 * @return void
	 *
	 * @deprecated 2.0.0 Use UploadQueue for background uploads instead
	 */
	public static function create( $plugin ) {
		self::instance( $plugin )->set_plugin( $plugin );
	}

}
