<?php

namespace Vimeify\Core\Integrations\Elementor;

use Vimeify\Core\Abstracts\BaseIntegration;
use Vimeify\Core\Integrations\Elementor\Widgets\VideosTable;

class Elementor extends BaseIntegration {

	/**
	 * Registers specific piece of functionality
	 * @return void
	 */
	public function register() {
		add_action( 'elementor/widgets/register', function ( $widgets_manager ) {
			if ( ! $widgets_manager || ! method_exists( $widgets_manager, 'register' ) ) {
				return;
			}
			/* @var  \Elementor\Widgets_Manager $widgets_manager */
			$widgets_manager->register( new VideosTable() );
		} );
	}

	/**
	 * Check if the integration can be activated.
	 * @return bool
	 */
	public function can_activate() {
		return defined( 'ELEMENTOR_VERSION' );
	}
}