<?php

namespace Vimeify\Core\Integrations\Bricks;

use Vimeify\Core\Abstracts\BaseIntegration;

class Bricks extends BaseIntegration {

	/**
	 * Registers specific piece of functionality
	 * @return void
	 */
	public function register() {
		add_action( 'init', function () {
			$path  = __DIR__ . DIRECTORY_SEPARATOR . 'Elements' . DIRECTORY_SEPARATOR;
			$files = apply_filters( 'vimeify_integrations_bricks_elements', [ $path . 'VideosTable.php' ] );
			if(!class_exists('\Bricks\Elements')) {
				return;
			}
			foreach ( $files as $file ) {
				\Bricks\Elements::register_element( $file );
			}
		}, 150 );
	}

	/**
	 * Check if the integration can be activated.
	 * @return bool
	 */
	public function can_activate() {
		return true;
	}
}