<?php
/********************************************************************
 * Copyright (C) 2024 Darko Gjorgjijoski (https://darkog.com/)
 * Copyright (C) 2024 IDEOLOGIX MEDIA Dooel (https://ideologix.com/)
 *
 * This file is property of IDEOLOGIX MEDIA Dooel (https://ideologix.com)
 * This file is part of Vimeify Plugin - https://wordpress.org/plugins/vimeify/
 *
 * Vimeify - Formerly "WP Vimeo Videos" is free software: you can redistribute
 * it and/or modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the License,
 * or (at your option) any later version.
 *
 * Vimeify - Formerly "WP Vimeo Videos" is distributed in the hope that it
 * will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this plugin. If not, see <https://www.gnu.org/licenses/>.
 *
 * Code developed by Darko Gjorgjijoski <dg@darkog.com>.
 **********************************************************************/

namespace Vimeify\Core\Abstracts;

use Vimeify\Core\Abstracts\Interfaces\SystemInterface;

abstract class BaseMigrator {

	/**
	 * The unique identifier of the migrator
	 * @var mixed
	 */
	protected $id;

	/**
	 * The name of the migrator
	 * @var string
	 */
	protected $name;

	/**
	 * The system instance
	 * @var SystemInterface
	 */
	protected $system;

	/**
	 * Constructor
	 * @param SystemInterface $system
	 */
	public function __construct( SystemInterface $system ) {
		$this->system = $system;
	}

	/**
	 * Returns the unique identifier of the migrator
	 * @return string
	 */
	public function get_id() {
		return $this->id;
	}

	/**
	 * Returns the name of the migrator
	 * @return string
	 */
	public function get_name() {
		return $this->name;
	}

	/**
	 * Returns the migrator steps
	 * @return array|\WP_Error
	 */
	abstract public function get_steps();


	/**
	 * Check if the it is possible to faciliate migration
	 * @return bool|\WP_Error
	 */
	abstract public function check_availability();

	/**
	 * Initializes the process
	 *
	 * @param array $data
	 *
	 * @return bool|\WP_Error
	 */
	abstract public function init( $data = array() );

	/**
	 * Initializes the process
	 *
	 * @param $step
	 * @param $page
	 * @param array $data
	 *
	 * @return bool|\WP_Error
	 */
	abstract public function do_step( $step, $page, $data = array() );

	/**
	 * Undoes the migration process
	 *
	 * @return bool
	 */
	abstract public function undo();

}
