/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/video/block.json"
/*!******************************!*\
  !*** ./src/video/block.json ***!
  \******************************/
(module) {

module.exports = /*#__PURE__*/JSON.parse('{"$schema":"https://json.schemastore.org/block.json","apiVersion":3,"name":"vimeify/video","title":"Vimeify Vimeo Video","textdomain":"vimeify","icon":"video-alt","category":"media","example":{},"editorScript":"file:./index.js","editorStyle":["vimeify-video-block"]}');

/***/ },

/***/ "./src/video/edit.js"
/*!***************************!*\
  !*** ./src/video/edit.js ***!
  \***************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _editor_scss__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./editor.scss */ "./src/video/editor.scss");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__);
/********************************************************************
 * Copyright (C) 2024 Darko Gjorgjijoski (https://darkog.com/)
 * Copyright (C) 2024 IDEOLOGIX MEDIA Dooel (https://ideologix.com/)
 *
 * This file is property of IDEOLOGIX MEDIA Dooel (https://ideologix.com)
 * This file is part of Vimeify Plugin - https://wordpress.org/plugins/vimeify/
 *
 * Vimeify - Formerly "WP Vimeo Videos" is free software: you can redistribute
 * it and/or modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the License,
 * or (at your option) any later version.
 *
 * Vimeify - Formerly "WP Vimeo Videos" is distributed in the hope that it
 * will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this plugin. If not, see <https://www.gnu.org/licenses/>.
 *
 * Code developed by Darko Gjorgjijoski <dg@darkog.com>.
 **********************************************************************/








const filterViewPrivacyOptions = options => {
  const newOptions = {};
  for (let i in options) {
    if (options[i].available) {
      newOptions[i] = options[i];
    }
  }
  return newOptions;
};
const Edit = ({
  attributes,
  setAttributes
}) => {
  const VimeifyAPICore = window['Vimeify'] ? window['Vimeify'] : null;
  const minSearchCharacters = 2;
  const notifyEndpoint = window['Vimeify_Admin']['upload_block_options'] && window['Vimeify_Admin']['upload_block_options']['notifyEndpoint'] ? window['Vimeify_Admin']['upload_block_options']['notifyEndpoint'] : '';
  const methods = window['Vimeify_Admin']['upload_block_options']['methods'] ? window['Vimeify_Admin']['upload_block_options']['methods'] : {};
  const nonce = window['Vimeify_Admin']['upload_block_options']['nonce'] ? window['Vimeify_Admin']['upload_block_options']['nonce'] : '';
  const restBase = window['Vimeify_Admin']['upload_block_options']['restBase'] ? window['Vimeify_Admin']['upload_block_options']['restBase'] : '';
  const accessToken = window['Vimeify_Admin']['upload_block_options']['accessToken'] ? window['Vimeify_Admin']['upload_block_options']['accessToken'] : '';
  const isViewPrivacyEnabled = window['Vimeify_Admin']['upload_block_options']['upload_form_options']['enable_view_privacy'] ? 1 : 0;
  const viewPrivacyOptions = isViewPrivacyEnabled ? filterViewPrivacyOptions(window['Vimeify_Admin']['upload_block_options']['upload_form_options']['privacy_view']) : [];
  const defaultViewPrivacy = Object.keys(viewPrivacyOptions).find(key => {
    return true === viewPrivacyOptions[key].default;
  });
  const isFoldersEnabled = window['Vimeify_Admin']['upload_block_options']['upload_form_options']['enable_folders'] ? 1 : 0;
  const defaultFolder = window['Vimeify_Admin']['upload_block_options']['upload_form_options']['default_folder'];
  const blockProps = (0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__.useBlockProps)();
  const dropdownPlaceholder = {
    label: 'Select result...',
    value: ''
  };
  const [type, setType] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)('');
  const [title, setTitle] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)('');
  const [description, setDescription] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)('');
  const [file, setFile] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)(null);
  const [value, setValue] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)(null);
  const [viewPrivacy, setViewPrivacy] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)(defaultViewPrivacy);
  const [folder, setFolder] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)(defaultFolder.uri);
  const [isUploading, setUploading] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)(false);
  const [uploadProgress, setUploadProgress] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)(0);
  const [folderSearch, setFolderSearch] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)('');
  const [folderResults, setFolderResults] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)([]);
  const [remoteSearch, setRemoteSearch] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)('');
  const [remoteResults, setRemoteResults] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)([]);
  const [localSearch, setLocalSearch] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)('');
  const [localResults, setLocalResults] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)([]);
  const {
    savePost
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.useDispatch)('core/editor');
  const handleUploadSave = event => {
    if (!VimeifyAPICore.Uploader.validateVideo(file)) {
      alert((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('Please select valid video file.', 'vimeify'));
      return false;
    }
    const uploader = new VimeifyAPICore.Uploader(accessToken, file, {
      'title': title,
      'description': description,
      'privacy': viewPrivacy,
      'folder': folder,
      'wp': {
        'notify_endpoint': notifyEndpoint
      },
      'beforeStart': function () {
        setUploading(true);
        setUploadProgress(0.25);
      },
      'onProgress': function (bytesUploaded, bytesTotal) {
        setUploadProgress((bytesUploaded / bytesTotal * 100).toFixed(2));
      },
      'onSuccess': function (response, currentUpload) {
        setType('');
        setAttributes({
          currentValue: currentUpload.uri
        });
        savePost();
      },
      'onError': function (error) {
        setUploading(false);
        alert('Vimeo upload error.');
      },
      'onVideoCreateError': function (error) {
        let message = '';
        const parsedError = JSON.parse(error);
        if (parsedError.hasOwnProperty('invalid_parameters')) {
          message = parsedError['invalid_parameters'][0]['developer_message'];
        } else {
          message = parsedError['developer_message'];
        }
        setUploading(false);
        alert(message);
      },
      'onWPNotifyError': function (error) {
        let message = '';
        const parsedError = JSON.parse(error);
        if (parsedError.hasOwnProperty('data')) {
          message = parsedError.data;
        } else {
          message = 'Error notifying WordPress about the file upload.';
        }
        setUploading(target, true);
        alert(message);
      }
    });
    uploader.start();
  };
  const saveRemoteSearch = event => {
    setType('');
    setAttributes({
      currentValue: value
    });
  };
  const saveLocalSearch = event => {
    setType('');
    setAttributes({
      currentValue: value
    });
  };
  const handleClear = event => {
    setType('');
    setAttributes({
      currentValue: ''
    });
  };
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useEffect)(() => {
    const delayDebounceFn = setTimeout(() => {
      if (remoteSearch.length > minSearchCharacters) {
        const profile = new VimeifyAPICore.Profile(accessToken);
        profile.search({
          'page': 1,
          'per_page': 100,
          'query': remoteSearch,
          'sort': 'date',
          'direction': 'desc',
          'onSuccess': function (response) {
            if (response.data.length > 0) {
              setRemoteResults(response.data);
            }
          },
          'onError': function (response) {
            console.warn('Vimeify: Unable to search remote profile.');
            console.warn(response);
            alert('Search error: ' + response.message);
          }
        });
      }
    }, 800);
    return () => clearTimeout(delayDebounceFn);
  }, [remoteSearch]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useEffect)(() => {
    const delayDebounceFn = setTimeout(async () => {
      if (localSearch.length > minSearchCharacters) {
        try {
          const response = await fetch(restBase + "vimeify/v1/videos?s=" + localSearch + '&_wpnonce=' + nonce);
          const body = await response.json();
          setLocalResults(body?.data);
        } catch (e) {
          console.warn('Error searching local videos:');
          console.warn(e);
          alert('Search error: ' + e.message);
        }
      }
    }, 800);
    return () => clearTimeout(delayDebounceFn);
  }, [localSearch]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useEffect)(() => {
    const delayDebounceFn = setTimeout(async () => {
      if (folderSearch.length > minSearchCharacters) {
        try {
          const response = await fetch(restBase + "vimeify/v1/folders?query=" + folderSearch + '&_wpnonce=' + nonce);
          const body = await response.json();
          setFolderResults([defaultFolder].concat(body?.data ? body?.data : []));
        } catch (e) {
          console.warn('Error searching folders:');
          console.warn(e);
          alert('Search error: ' + e.message);
        }
      }
    }, 800);
    return () => clearTimeout(delayDebounceFn);
  }, [folderSearch]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
    ...blockProps,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
      className: "vimeify-upload-form",
      children: [attributes.currentValue && '' !== attributes.currentValue && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("iframe", {
          width: "auto",
          height: "400",
          src: 'https://player.vimeo.com/video/' + attributes.currentValue.replace('/videos/', ''),
          frameBorder: "0",
          allow: "autoplay; encrypted-media",
          webkitallowfullscreen: true,
          mozallowfullscreen: true,
          allowFullScreen: true
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("hr", {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
          style: {
            textAlign: 'center'
          },
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
            onClick: handleClear,
            variant: "secondary",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('Clear', 'vimeify')
          })
        })]
      }), !attributes.currentValue || '' === attributes.currentValue ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("h3", {
          className: "vimeify-block-title",
          children: "Vimeo"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
          style: {
            marginBottom: '15px'
          },
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.RadioControl, {
            label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('Upload/Select Vimeo Video', 'vimeify'),
            selected: type,
            options: [{
              label: methods.upload,
              value: 'upload'
            }, {
              label: methods.local,
              value: 'local'
            }, {
              label: methods.search,
              value: 'search'
            }],
            onChange: value => setType(value)
          })
        }), type === 'upload' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
          className: "vimeify-upload-form-inner",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.TextControl, {
            label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('Title', 'vimeify'),
            value: title,
            onChange: value => setTitle(value)
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.TextareaControl, {
            label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('Description', 'vimeify'),
            value: description,
            onChange: value => setDescription(value)
          }), parseInt(isViewPrivacyEnabled) === 1 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.SelectControl, {
            label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('View Privacy', 'vimeify'),
            help: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('Who will be able to view this video', 'vimeify'),
            value: viewPrivacy,
            options: Object.keys(viewPrivacyOptions).map(key => {
              return {
                label: viewPrivacyOptions[key].name,
                value: key
              };
            }),
            onChange: newValue => setViewPrivacy(newValue)
          }), parseInt(isFoldersEnabled) === 1 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.TextControl, {
              label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('Folder', 'vimeify'),
              placeholder: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('Search for folders or leave blank', 'vimeify'),
              value: folderSearch,
              help: folderResults.length === 0 ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('Where this video should be uploaded to?', 'vimeify') : "",
              onChange: value => setFolderSearch(value)
            }), folderResults.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.SelectControl, {
              help: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('Where this video should be uploaded to?', 'vimeify'),
              value: folder,
              options: folderResults.map(item => {
                return {
                  label: item.name,
                  value: item.uri
                };
              }),
              onChange: newValue => setFolder(newValue)
            })]
          }), file && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("p", {
            children: ["Selected: ", file.name]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.FormFileUpload, {
            accept: "video/*",
            variant: "secondary",
            onChange: event => setFile(event.currentTarget.files[0]),
            children: file ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('Replace Video', 'vimeify') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('Select Video', 'vimeify')
          }), isUploading && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
            className: "vimeify-progress",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
              className: "vimeify-progress-value",
              style: {
                width: uploadProgress + '%'
              }
            })
          }), file && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
            style: {
              marginTop: '10px'
            },
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
              onClick: handleUploadSave,
              variant: "primary",
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('Upload', 'vimeify')
            })
          })]
        }), type === 'search' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
          className: "vimeify-remote-search-form",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.TextControl, {
            label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('Search your Vimeo.com account', 'vimeify'),
            value: remoteSearch,
            onChange: value => setRemoteSearch(value)
          }), remoteResults.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.SelectControl, {
            label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('Videos List', 'vimeify'),
            value: value,
            options: [dropdownPlaceholder].concat(remoteResults.map(item => {
              return {
                label: item.name,
                value: item.uri
              };
            })),
            onChange: selected => setValue(selected)
          }), value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
            onClick: saveRemoteSearch,
            variant: "primary",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('Save', 'vimeify')
          })]
        }), type === 'local' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
          className: "vimeify-local-search-form",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.TextControl, {
            label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('Search your Local Library', 'vimeify'),
            value: localSearch,
            onChange: value => setLocalSearch(value)
          }), localResults.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.SelectControl, {
            label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('Videos List', 'vimeify'),
            value: value,
            options: [dropdownPlaceholder].concat(localResults.map(item => {
              return {
                label: item.name,
                value: item.uri
              };
            })),
            onChange: selected => setValue(selected)
          }), value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
            onClick: saveLocalSearch,
            variant: "primary",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__.__)('Save', 'vimeify')
          })]
        })]
      }) : ""]
    })
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Edit);

/***/ },

/***/ "./src/video/editor.scss"
/*!*******************************!*\
  !*** ./src/video/editor.scss ***!
  \*******************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ },

/***/ "./src/video/save.js"
/*!***************************!*\
  !*** ./src/video/save.js ***!
  \***************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/********************************************************************
 * Copyright (C) 2024 Darko Gjorgjijoski (https://darkog.com/)
 * Copyright (C) 2024 IDEOLOGIX MEDIA Dooel (https://ideologix.com/)
 *
 * This file is property of IDEOLOGIX MEDIA Dooel (https://ideologix.com)
 * This file is part of Vimeify Plugin - https://wordpress.org/plugins/vimeify/
 *
 * Vimeify - Formerly "WP Vimeo Videos" is free software: you can redistribute
 * it and/or modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the License,
 * or (at your option) any later version.
 *
 * Vimeify - Formerly "WP Vimeo Videos" is distributed in the hope that it
 * will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this plugin. If not, see <https://www.gnu.org/licenses/>.
 *
 * Code developed by Darko Gjorgjijoski <dg@darkog.com>.
 **********************************************************************/

const Save = () => {
  return null;
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Save);

/***/ },

/***/ "@wordpress/block-editor"
/*!*************************************!*\
  !*** external ["wp","blockEditor"] ***!
  \*************************************/
(module) {

module.exports = window["wp"]["blockEditor"];

/***/ },

/***/ "@wordpress/blocks"
/*!********************************!*\
  !*** external ["wp","blocks"] ***!
  \********************************/
(module) {

module.exports = window["wp"]["blocks"];

/***/ },

/***/ "@wordpress/components"
/*!************************************!*\
  !*** external ["wp","components"] ***!
  \************************************/
(module) {

module.exports = window["wp"]["components"];

/***/ },

/***/ "@wordpress/data"
/*!******************************!*\
  !*** external ["wp","data"] ***!
  \******************************/
(module) {

module.exports = window["wp"]["data"];

/***/ },

/***/ "@wordpress/element"
/*!*********************************!*\
  !*** external ["wp","element"] ***!
  \*********************************/
(module) {

module.exports = window["wp"]["element"];

/***/ },

/***/ "@wordpress/i18n"
/*!******************************!*\
  !*** external ["wp","i18n"] ***!
  \******************************/
(module) {

module.exports = window["wp"]["i18n"];

/***/ },

/***/ "react/jsx-runtime"
/*!**********************************!*\
  !*** external "ReactJSXRuntime" ***!
  \**********************************/
(module) {

module.exports = window["ReactJSXRuntime"];

/***/ }

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Check if module exists (development only)
/******/ 		if (__webpack_modules__[moduleId] === undefined) {
/******/ 			var e = new Error("Cannot find module '" + moduleId + "'");
/******/ 			e.code = 'MODULE_NOT_FOUND';
/******/ 			throw e;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
(() => {
/*!****************************!*\
  !*** ./src/video/index.js ***!
  \****************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _block_json__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./block.json */ "./src/video/block.json");
/* harmony import */ var _edit__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./edit */ "./src/video/edit.js");
/* harmony import */ var _save__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./save */ "./src/video/save.js");
/********************************************************************
 * Copyright (C) 2024 Darko Gjorgjijoski (https://darkog.com/)
 * Copyright (C) 2024 IDEOLOGIX MEDIA Dooel (https://ideologix.com/)
 *
 * This file is property of IDEOLOGIX MEDIA Dooel (https://ideologix.com)
 * This file is part of Vimeify Plugin - https://wordpress.org/plugins/vimeify/
 *
 * Vimeify - Formerly "WP Vimeo Videos" is free software: you can redistribute
 * it and/or modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the License,
 * or (at your option) any later version.
 *
 * Vimeify - Formerly "WP Vimeo Videos" is distributed in the hope that it
 * will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this plugin. If not, see <https://www.gnu.org/licenses/>.
 *
 * Code developed by Darko Gjorgjijoski <dg@darkog.com>.
 **********************************************************************/






// Destructure the json file to get the name of the block
// For more information on how this works, see: https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Destructuring_assignment
const {
  name
} = _block_json__WEBPACK_IMPORTED_MODULE_1__;

// Register the block
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_0__.registerBlockType)(name, {
  attributes: {
    currentValue: {
      type: 'string'
    }
  },
  edit: _edit__WEBPACK_IMPORTED_MODULE_2__["default"],
  save: _save__WEBPACK_IMPORTED_MODULE_3__["default"]
});
})();

/******/ })()
;
//# sourceMappingURL=index.js.map