/**
 * Bento - WordPress Plugin Bundler Configuration
 *
 * This file configures Bento for your WordPress plugin
 */

module.exports = {
    // Entry points - directories containing your source files
    entry: {
        admin: 'scripts/admin',
        frontend: 'scripts/frontend',
        shared: 'scripts/shared'
    },

    // Output directory where built files will be placed
    output: 'public',

    // Build options
    clean: true, // Clean output directory before build

    // WordPress specific options
    wordpress: {
        // Plugin text domain (for translations)
        textDomain: 'vimeify',

        // Generate WordPress-style handles for enqueuing
        generateHandles: true,

        // WordPress coding standards compliance
        wpCodingStandards: true
    },

    // Advanced options
    advanced: {
        // Automatically detect and install npm dependencies
        autoInstallDeps: true,

        // Transpile modern JS to older browsers
        transpile: {
            target: 'es5',
            browsers: ['> 1%', 'last 2 versions', 'ie >= 11']
        },

        // CSS preprocessing options
        css: {
            autoprefixer: true,
            purgeUnused: false  // Remove unused CSS (be careful with WordPress)
        },

        // Bundle optimization
        optimization: {
            splitChunks: true,     // Create separate chunks for shared code
            treeshake: true,       // Remove unused code
            compress: true         // Additional compression
        }
    }
};
