<?php
/**
 * Template Name: Video Single.
 *
 * @package WordPress
 */
 if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
 
//get_header();


?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<?php 
if ( apply_filters( 'astra_header_profile_gmpg_link', true ) ) {
	?>
	 <link rel="profile" href="https://gmpg.org/xfn/11"> 
	 <?php
}
$excerpt = '';
global $post;
$videogate_video_source = (get_post_meta($post->ID, '_videogate_video_source', true) && !empty(get_post_meta($post->ID, '_videogate_video_source', true)))? get_post_meta($post->ID, '_videogate_video_source', true): 'youtube';
$videogate_video_id = (get_post_meta($post->ID, '_videogate_video_id', true) && !empty(get_post_meta($post->ID, '_videogate_video_id', true)))? get_post_meta($post->ID, '_videogate_video_id', true): '';

if (has_excerpt()) {
	$excerpt = wp_strip_all_tags(get_the_excerpt());
} 
?>
<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<div id="container">    
	<div id="player" data-plyr-provider="<?php echo esc_attr($videogate_video_source); ?>" data-plyr-embed-id="<?php echo esc_attr($videogate_video_id); ?>"></div>
</div>
<script>
  const player = new Plyr('#player');
</script>
<?php   wp_footer(); ?>
</body>
</html>