jQuery(document).ready(function($) {
    // Duplicate testimonials for continuous scrolling
    $('.scroll-inner').each(function() {
        const $this = $(this);
        const $testimonials = $this.children('.testimonial').clone();
        $this.append($testimonials);

        // Ensure the scroll resets smoothly
        $this.css('animation-iteration-count', 'infinite');
    });

    // Optional: Reset scroll position on animation end to avoid glitches
    $('.scroll-inner').on('animationiteration webkitAnimationIteration', function() {
        const $this = $(this);
        const height = $this.height() / 2; // Half the height for reset
        $this.css('transform', 'translateY(0)');
        setTimeout(() => {
            $this.css('animation', 'none');
            $this.css('animation', ''); // Trigger reflow
        }, 10);
    });

    // Pause on hover if enabled
    if (vertim_settings.pause_on_hover) {
        $('.testimonial').hover(function() {
            $(this).closest('.scroll-inner').css('animation-play-state', 'paused');
        }, function() {
            $(this).closest('.scroll-inner').css('animation-play-state', 'running');
        });
    }
});