jQuery(document).ready(function($) {
    'use strict';

    // 1. FILTER & SEARCH (Settings Page Only)
    if ($('.vlocker-filter-btn').length > 0) {
        let currentFilter = 'all';
        let currentSearch = '';
        const rows = $('#the-list tr');
        const filterBtns = $('.vlocker-filter-btn');
        const searchBox = $('#vlocker-search');

        function renderRows() {
            rows.each(function() {
                const row = $(this);
                const name = row.find('.plugin-title strong').text().toLowerCase();
                const isActive = row.data('active') == 1;
                const isLocked = row.data('locked') == 1;

                let matchesFilter = false;
                if (currentFilter === 'all') matchesFilter = true;
                else if (currentFilter === 'active' && isActive) matchesFilter = true;
                else if (currentFilter === 'locked' && isLocked) matchesFilter = true;

                const matchesSearch = name.includes(currentSearch);
                (matchesFilter && matchesSearch) ? row.show() : row.hide();
            });
        }

        filterBtns.on('click', function() {
            filterBtns.removeClass('active button-primary');
            $(this).addClass('active button-primary');
            currentFilter = $(this).data('filter');
            renderRows();
        });
        
        searchBox.on('input', function() {
            currentSearch = $(this).val().toLowerCase();
            renderRows();
        });
    }

    // 2. THE CLEAN DELETE HANDLER
    $(document).on('click', '.vlocker-secure-delete', function(e) {
        e.preventDefault();
        
        const pluginSlug = $(this).data('plugin');
        const href = $(this).attr('href');

        if (!pluginSlug) {
            window.location.href = href;
            return;
        }

        window.pendingDeletePlugin = pluginSlug;
        window.originalDeleteLink = href;
        
        $('#vlocker-delete-modal').fadeIn(200);
        $('#vlocker-cancel-delete').focus();
    });

    // 3. MODAL HANDLERS
    function closeModal() {
        const $modal = $('#vlocker-delete-modal');
        const $btn = $('#vlocker-confirm-delete');
        
        // Only close if not currently processing
        if ($btn.prop('disabled')) return;

        $modal.fadeOut(200);
        window.pendingDeletePlugin = null;
        $btn.prop('disabled', false).text(vlocker_vars.modal_btn_text);
        $('.vlocker-modal-box').css('opacity', '1');
    }

    $('#vlocker-cancel-delete').on('click', closeModal);

    $(document).on('keyup', function(e) {
        if (e.key === "Escape" && $('#vlocker-delete-modal').is(':visible')) {
            closeModal();
        }
    });
    
    // 4. IMPROVED CONFIRM HANDLER (With Error Handling)
    $('#vlocker-confirm-delete').on('click', function() {
        const btn = $(this);
        const action = $('input[name="vlocker_delete_action"]:checked').val();
        const modalBox = $('.vlocker-modal-box');
        
        // UI Loading State
        btn.prop('disabled', true).text(vlocker_vars.processing_text);
        modalBox.css('opacity', '0.7');
        
        if (action === 'permanent') {
            $.post(vlocker_vars.ajax_url, {
                action: 'vlocker_cleanup_plugin',
                plugin: window.pendingDeletePlugin,
                nonce: vlocker_vars.nonce_cleanup
            })
            .done(function(response) {
                if (response.success) {
                    window.location.href = window.originalDeleteLink;
                } else {
                    // Show error message from server
                    alert(response.data.message || vlocker_vars.error_text);
                    // Reset UI
                    btn.prop('disabled', false).text(vlocker_vars.modal_btn_text);
                    modalBox.css('opacity', '1');
                }
            })
            .fail(function() {
                // Handle network/server errors
                alert(vlocker_vars.error_text);
                // Reset UI
                btn.prop('disabled', false).text(vlocker_vars.modal_btn_text);
                modalBox.css('opacity', '1');
            });
        } else {
            // Temporary delete (just redirect)
            window.location.href = window.originalDeleteLink;
        }
    });

});