<?php
/**
 * Uninstall Vehizo Vehicle Management
 *
 * Fired when the plugin is uninstalled.
 * Removes all plugin data from the database.
 *
 * @package      Vehizo
 * @version      4.1.3
 * @author       Thorsten Glander
 * @since        1.0.0
 */

// Exit if accessed directly or not uninstalling
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Delete all plugin options
$options_to_delete = array(
    // Module Settings
    'vehizo_contact_module_active',
    'vehizo_statistics_module_active',
    'vehizo_wishlist_module_active',

    // Display Settings
    'vehizo_layout',
    'vehizo_grid_columns',
    'vehizo_show_filter',
    'vehizo_overview_page_id',
    'vehizo_posts_per_page',

    // Color Settings
    'vehizo_primary_color',
    'vehizo_secondary_color',
    'vehizo_button_hover_color',
    'vehizo_text_color',
    'vehizo_container_bg_color',
    'vehizo_card_bg_color',
    'vehizo_card_border_color',
    'vehizo_card_border_width',
    'vehizo_card_radius',
    'vehizo_card_box_shadow',
    'vehizo_specs_bg_color',
    'vehizo_card_title_color',
    'vehizo_card_title_fontweight',

    // Font Settings
    'vehizo_font_size',
    'vehizo_heading_size',

    // Currency Settings
    'vehizo_currency_symbol',
    'vehizo_currency_position',

    // Filter Settings
    'vehizo_filter_style',
    'vehizo_filter_layout',
    'vehizo_filter_spacing',
    'vehizo_filter_border_radius',
    'vehizo_filter_shadow',
    'vehizo_card_spacing',

    // Contact Module Settings
    'vehizo_contact_email',
    'vehizo_contact_subject',
    'vehizo_button_style',

    // Import Settings
    'vehizo_mobile_username',
    'vehizo_mobile_password',
    'vehizo_mobile_api_url',
    'vehizo_last_cron_status',
    'vehizo_last_cron_import',
    'vehizo_cron_interval',

    // Migration Flags
    'vehizo_german_values_migrated',

    // Other Settings
    'vehizo_version'
);

foreach ($options_to_delete as $option) {
    delete_option($option);
}

// Delete all vehicles and their metadata
$vehicles = get_posts(array(
    'post_type'      => 'vehizo_vehicle',
    'numberposts'    => -1,
    'post_status'    => 'any',
    'fields'         => 'ids'
));

foreach ($vehicles as $vehicle_id) {
    // Force delete (bypass trash)
    wp_delete_post($vehicle_id, true);
}

// Clean up any remaining post meta for vehizo vehicles
global $wpdb;
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Uninstall cleanup, bulk delete more efficient than individual post meta deletions
$wpdb->query(
    $wpdb->prepare(
        "DELETE FROM {$wpdb->postmeta} WHERE meta_key LIKE %s",
        $wpdb->esc_like('vehizo_') . '%'
    )
);

// Clean up post meta from deleted vehicles (orphaned meta)
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Uninstall cleanup with JOIN to remove orphaned meta, no alternative with WP functions
$wpdb->query(
    "DELETE pm FROM {$wpdb->postmeta} pm
    LEFT JOIN {$wpdb->posts} p ON pm.post_id = p.ID
    WHERE p.ID IS NULL"
);

// Clear any scheduled cron jobs
$cron_hooks = array(
    'vehizo_cron_import',
    'vehizo_cleanup_wishlist'
);

foreach ($cron_hooks as $hook) {
    $timestamp = wp_next_scheduled($hook);
    if ($timestamp) {
        wp_unschedule_event($timestamp, $hook);
    }
    // Also clear all scheduled instances
    wp_clear_scheduled_hook($hook);
}

// Flush rewrite rules to clean up custom post type permalinks
flush_rewrite_rules();
