<?php
/**
 * The template for displaying a single Vehizo vehicle.
 * This template can be overridden by copying it to yourtheme/single-vehizo_vehicle.php.
 *
 * @package Vehizo
 * @version 4.2.1
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

get_header(); ?>

<div class="vehizo-container">
	<?php
	while ( have_posts() ) :
		the_post();
		$post_id = get_the_ID();

		// Sicherheitsprüfung: Ist es wirklich ein Vehicle?
		if (get_post_type($post_id) !== 'vehizo_vehicle') {
			global $post;
			if ($post && $post->post_type === 'vehizo_vehicle') {
				$post_id = $post->ID;
			} else {
				$queried_object = get_queried_object();
				if ($queried_object && $queried_object->post_type === 'vehizo_vehicle') {
					$post_id = $queried_object->ID;
				}
			}
		}

		// --- Daten-Vorbereitung ---
		$price       = get_post_meta( $post_id, 'vehizo_price', true );
		$make        = get_post_meta( $post_id, 'vehizo_make', true );
		$model       = get_post_meta( $post_id, 'vehizo_model', true );
		$gallery_ids = array_filter( explode( ',', get_post_meta( $post_id, 'vehizo_gallery', true ) ) );
		$main_image_id = has_post_thumbnail() ? get_post_thumbnail_id() : ( ! empty( $gallery_ids ) ? $gallery_ids[0] : 0 );
		
		if ( $main_image_id && ! in_array( $main_image_id, $gallery_ids ) ) {
			array_unshift( $gallery_ids, $main_image_id );
		}
		
		$formatted_price = __( 'On request', 'vehizo-vehicle-management' );
		if ( ! empty( $price ) && is_numeric( $price ) ) {
			$currency_symbol   = get_option( 'vehizo_currency_symbol', '€' );
			$currency_position = get_option( 'vehizo_currency_position', 'after' );
			$formatted_number  = number_format_i18n( absint( $price ) );
			$formatted_price   = ( $currency_position === 'before' ) ? $currency_symbol . ' ' . $formatted_number : $formatted_number . ' ' . $currency_symbol;
		}

		$quick_specs = [
			'firstRegistration' => [ 'label' => __( 'First Registration', 'vehizo-vehicle-management' ), 'icon' => 'M9 11H7v2h2v-2zm4 0h-2v2h2v-2zm4 0h-2v2h2v-2zm2-7h-1V2h-2v2H8V2H6v2H5c-1.1 0-1.99.9-1.99 2L3 20c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 16H5V9h14v11z' ],
			'mileage'           => [ 'label' => __( 'Mileage', 'vehizo-vehicle-management' ), 'icon' => 'M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z', 'suffix' => ' km' ],
			'fuelType'          => [ 'label' => __( 'Fuel Type', 'vehizo-vehicle-management' ), 'icon' => 'M19.77 7.23l.01-.01-3.72-3.72L15 4.56l2.11 2.11c-.94.36-1.61 1.26-1.61 2.33 0 1.38 1.12 2.5 2.5 2.5.84 0 1.58-.41 2.03-1.03L19.77 7.23zM9.5 11.5c0 .83-.67 1.5-1.5 1.5s-1.5-.67-1.5-1.5.67-1.5 1.5-1.5 1.5.67 1.5 1.5zM18 15v3H6v-3H4v3c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2v-3h-2z' ],
			'power'             => [ 'label' => __( 'Power', 'vehizo-vehicle-management' ), 'icon' => 'M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-1 17.93c-3.94-.49-7-3.85-7-7.93 0-.62.08-1.21.21-1.79L9 15v1c0 1.1.9 2 2 2v1.93zm6.9-2.54c-.26-.81-1-1.39-1.9-1.39h-1v-3c0-.55-.45-1-1-1H8v-2h2c.55 0 1-.45 1-1V7h2c1.1 0 2-.9 2-2v-.41c2.93 1.19 5 4.06 5 7.41 0 2.08-.8 3.97-2.1 5.39z', 'suffix' => ' PS' ],
			'transmission'      => [ 'label' => __( 'Transmission', 'vehizo-vehicle-management' ), 'icon' => 'M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-6h2v6zm0-8h-2V7h2v2z' ],
			'number_of_owners'  => [ 'label' => __( 'Owners', 'vehizo-vehicle-management' ), 'icon' => 'M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z' ],
			'next_inspection'   => [ 'label' => __( 'Next HU', 'vehizo-vehicle-management' ), 'icon' => 'M19 3h-1V1h-2v2H8V1H6v2H5c-1.11 0-1.99.9-1.99 2L3 19c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H5V8h14v11zM7 10h5v5H7z' ],
		];

		$tech_specs = [
			__('Engine & Performance', 'vehizo-vehicle-management') => [
				'make' => __('Make', 'vehizo-vehicle-management'),
				'model' => __('Model', 'vehizo-vehicle-management'),
				'power' => __('Power (PS)', 'vehizo-vehicle-management'),
				'fuelType' => __('Fuel Type', 'vehizo-vehicle-management'),
                'engine_displacement' => __('Displacement (ccm)', 'vehizo-vehicle-management'),
				'vin' => __('VIN', 'vehizo-vehicle-management'),
			],
			__('Dimensions & Body', 'vehizo-vehicle-management') => [
				'doors' => __('Doors', 'vehizo-vehicle-management'),
				'seats' => __('Seats', 'vehizo-vehicle-management'),
                'color' => __('Color', 'vehizo-vehicle-management'),
                'vehicleType' => __('Vehicle Type', 'vehizo-vehicle-management'),
			],
		];
		?>
		
		<article id="post-<?php the_ID(); ?>" <?php post_class( 'vehizo-single-vehicle-article' ); ?>>
			<div class="vehizo-single">
				<div class="vehizo-single__header">
					<!-- Left: Gallery + Content below -->
					<div class="vehizo-single__gallery">
						<?php if ( ! empty( $gallery_ids ) ) : ?>
							<div class="vehizo-gallery-column">
								<!-- Gallery Section -->
								<div class="vehizo-gallery-content">
									<div class="vehizo-gallery-container">
										<!-- Vertical Thumbnail Strip -->
										<div class="vehizo-thumbnail-strip">
											<?php foreach ( $gallery_ids as $index => $image_id ) :
												$thumb_url = wp_get_attachment_image_url( $image_id, 'thumbnail' );
												$is_active = ($index === 0);
											?>
												<div class="vehizo-thumbnail <?php echo $is_active ? 'active' : ''; ?>"
													 data-index="<?php echo esc_attr($index); ?>"
													 data-image="<?php echo esc_url( wp_get_attachment_image_url( $image_id, 'large' ) ); ?>">
													<img src="<?php echo esc_url($thumb_url); ?>"
														 alt="<?php echo esc_attr( get_the_title( $image_id ) ); ?>"
														 loading="<?php echo esc_attr($index > 3 ? 'lazy' : 'eager'); ?>">
												</div>
											<?php endforeach; ?>
										</div>

										<!-- Main Image Display -->
										<div class="vehizo-main-image-container">
											<img class="vehizo-main-image"
												 src="<?php echo esc_url( wp_get_attachment_image_url( $gallery_ids[0], 'large' ) ); ?>"
												 alt="<?php the_title_attribute(); ?>"
												 loading="eager">

											<!-- Navigation Arrows -->
											<button class="vehizo-gallery-nav vehizo-gallery-prev" aria-label="Previous image">‹</button>
											<button class="vehizo-gallery-nav vehizo-gallery-next" aria-label="Next image">›</button>

											<!-- Image Counter -->
											<div class="vehizo-image-counter">
												<span class="current">1</span> / <span class="total"><?php echo count($gallery_ids); ?></span>
											</div>

											<!-- Fullscreen Button -->
											<button class="vehizo-fullscreen-btn" aria-label="View fullscreen">⛶</button>
										</div>
									</div>
								</div>

							</div>

							<!-- Lightbox Modal -->
							<div class="vehizo-lightbox" id="vehizo-lightbox">
								<div class="vehizo-lightbox__overlay"></div>
								<div class="vehizo-lightbox__content">
									<button class="vehizo-lightbox__close">&times;</button>
									<button class="vehizo-lightbox__prev">&#8249;</button>
									<button class="vehizo-lightbox__next">&#8250;</button>
									<img class="vehizo-lightbox__image" src="" alt="">
									<div class="vehizo-lightbox__counter">
										<span class="vehizo-lightbox__current">1</span> / <span class="vehizo-lightbox__total"><?php echo count($gallery_ids); ?></span>
									</div>
								</div>
							</div>
						<?php else : ?>
							<div class="vehizo-single__main-image-placeholder">
								<svg width="100" height="100" viewBox="0 0 24 24" fill="currentColor">
									<path d="M21 19V5c0-1.1-.9-2-2-2H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2zM8.5 13.5l2.5 3.01L14.5 12l4.5 6H5l3.5-4.5z"/>
								</svg>
								<p><?php esc_html_e('No images available', 'vehizo-vehicle-management'); ?></p>
							</div>
						<?php endif; ?>

						<!-- Tabs IMMER sichtbar - direkt nach Galerie -->
						<div class="vehizo-tabs-section" style="margin-top: 1rem; background: white; padding: 1.5rem; border-radius: 8px; box-shadow: 0 1px 3px rgba(0,0,0,0.1);">
							<div class="vehizo-single__tabs">
								<button class="vehizo-single__tab active" data-tab="description"><?php esc_html_e( 'Description', 'vehizo-vehicle-management' ); ?></button>
								<button class="vehizo-single__tab" data-tab="basic"><?php esc_html_e( 'Basic Data', 'vehizo-vehicle-management' ); ?></button>
								<button class="vehizo-single__tab" data-tab="technical"><?php esc_html_e( 'Technical Data', 'vehizo-vehicle-management' ); ?></button>
							</div>

							<!-- Description Tab Content -->
							<div class="vehizo-single__tab-content active" id="tab-description">
								<h3 class="vehizo-heading-3" style="margin-bottom: 1rem; font-size: 1.25rem; font-weight: 600;"><?php esc_html_e( 'Vehicle Description', 'vehizo-vehicle-management' ); ?></h3>
								<div class="vehizo-text-body" style="line-height: 1.6; color: #374151;">
									<?php
									$content = get_the_content();
									if (!empty($content)) {
										the_content();
									} else {
										echo '<p style="color: #9ca3af;">' . esc_html__('No description available yet.', 'vehizo-vehicle-management') . '</p>';
									}
									?>
								</div>
							</div>

                            <?php
                            $features = get_the_terms($post_id, 'vehizo_feature');
                            if ($features && !is_wp_error($features)) :
                            ?>
                            <div class="vehizo-single__features-section" style="margin-top: 2rem;">
                                <h3 class="vehizo-heading-3" style="margin-bottom: 1rem; font-size: 1.25rem; font-weight: 600;"><?php esc_html_e('Features', 'vehizo-vehicle-management'); ?></h3>
                                <div class="vehizo-features-list" style="display: flex; flex-wrap: wrap; gap: 0.75rem;">
                                    <?php foreach ($features as $feature) : ?>
                                        <span class="vehizo-feature-tag" style="background-color: #eef2ff; color: #4338ca; padding: 0.5rem 1rem; border-radius: 9999px; font-size: 0.875rem; font-weight: 500;">
                                            <?php echo esc_html($feature->name); ?>
                                        </span>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                            <?php endif; ?>

							<!-- Basic Data Tab Content -->
							<div class="vehizo-single__tab-content" id="tab-basic" style="display: none;">
								<h3 class="vehizo-heading-3" style="margin-bottom: 1rem; font-size: 1.25rem; font-weight: 600;"><?php esc_html_e( 'Basic Data', 'vehizo-vehicle-management' ); ?></h3>
								<div class="vehizo-specs-table" style="display: grid; gap: 0.75rem;">
									<?php
									$basic_data = [
										'make' => __('Make', 'vehizo-vehicle-management'),
										'model' => __('Model', 'vehizo-vehicle-management'),
										'firstRegistration' => __('Year', 'vehizo-vehicle-management'),
										'mileage' => __('Mileage', 'vehizo-vehicle-management'),
										'color' => __('Color', 'vehizo-vehicle-management'),
									];
									foreach ($basic_data as $key => $label) {
										$value = get_post_meta($post_id, 'vehizo_' . $key, true);
										if ($key === 'mileage' && !empty($value)) {
											$value = number_format_i18n(absint($value)) . ' km';
										}
										if (!empty($value)) :
									?>
										<div class="vehizo-specs-group__item" style="display: flex; justify-content: space-between; padding: 0.75rem; background: #f9fafb; border-radius: 6px;">
											<span class="vehizo-specs-group__label" style="font-weight: 500; color: #6b7280;"><?php echo esc_html($label); ?></span>
											<span class="vehizo-specs-group__value" style="font-weight: 600; color: #111827;"><?php echo esc_html($value); ?></span>
										</div>
									<?php
										endif;
									}
									?>
								</div>
							</div>

							<!-- Technical Data Tab Content -->
							<div class="vehizo-single__tab-content" id="tab-technical" style="display: none;">
								<h3 class="vehizo-heading-3" style="margin-bottom: 1rem; font-size: 1.25rem; font-weight: 600;"><?php esc_html_e( 'Technical Data', 'vehizo-vehicle-management' ); ?></h3>
								<div class="vehizo-specs-table">
									<?php foreach ($tech_specs as $group_title => $fields) : ?>
									<div class="vehizo-specs-group" style="margin-bottom: 1.5rem;">
										<h4 class="vehizo-specs-group__title" style="font-size: 1rem; font-weight: 600; margin-bottom: 0.75rem; color: #374151;"><?php echo esc_html( $group_title ); ?></h4>
										<?php foreach ( $fields as $key => $label ) :
											$value = get_post_meta( $post_id, 'vehizo_' . $key, true );
											if ( ! empty( $value ) ) :
												?>
												<div class="vehizo-specs-group__item" style="display: flex; justify-content: space-between; padding: 0.75rem; background: #f9fafb; border-radius: 6px; margin-bottom: 0.5rem;">
													<span class="vehizo-specs-group__label" style="font-weight: 500; color: #6b7280;"><?php echo esc_html( $label ); ?></span>
													<span class="vehizo-specs-group__value" style="font-weight: 600; color: #111827;"><?php echo esc_html( $value ); ?></span>
												</div>
												<?php
											endif;
										endforeach;
										?>
									</div>
									<?php endforeach; ?>
								</div>
							</div>
						</div>

					</div>

					<!-- Right: Vehicle Info Sidebar -->
					<div class="vehizo-single__info">
						<h1 class="vehizo-single__title"><?php the_title(); ?></h1>
						<?php if ( ! empty( $make ) && ! empty( $model ) ) : ?>
							<p class="vehizo-single__subtitle"><?php echo esc_html( $make . ' ' . $model ); ?></p>
						<?php endif; ?>

                        <?php
                        $status = get_post_meta($post_id, 'vehizo_vehicle_status', true);
                        if ($status && $status !== 'available') : ?>
                            <div class="vehizo-status-badge vehizo-status-<?php echo esc_attr($status); ?>">
                                <?php echo esc_html(ucfirst($status)); ?>
                            </div>
                        <?php endif; ?>

						<div class="vehizo-single__price"><?php echo esc_html( $formatted_price ); ?></div>

						<div class="vehizo-single__quick-specs">
							<?php foreach ( $quick_specs as $key => $details ) :
								$meta_key = 'vehizo_' . $key;
								$value = get_post_meta( $post_id, $meta_key, true );
								if ( ! empty( $value ) ) :
									if ( $key === 'mileage' || $key === 'power' ) { $value = number_format_i18n( absint( $value ) ); }
									$value .= $details['suffix'] ?? '';
									?>
									<div class="vehizo-single__spec-item">
										<svg class="vehizo-single__spec-icon" fill="currentColor" viewBox="0 0 24 24"><path d="<?php echo esc_attr( $details['icon'] ); ?>"/></svg>
										<div class="vehizo-single__spec-content">
											<div class="vehizo-single__spec-label"><?php echo esc_html( $details['label'] ); ?></div>
											<div class="vehizo-single__spec-value"><?php echo esc_html( $value ); ?></div>
										</div>
									</div>
									<?php
								endif;
							endforeach;
							?>
						</div>

						<div class="vehizo-single__actions">
							<?php
							/**
							 * Hook for adding action buttons to the single vehicle page sidebar.
							 * @param int $post_id The ID of the current vehicle post.
							 */
							do_action( 'vehizo_single_vehicle_actions', $post_id );
							?>
						</div>
					</div>
				</div>

				<?php
				/**
				 * Hook for adding content after the main content area (e.g., contact form).
				 * @param int $post_id The ID of the current vehicle post.
				 */
				do_action( 'vehizo_after_single_vehicle_content', $post_id );
				?>
			</div>
		</article>

		<?php
	endwhile; // End of the loop.
	?>
</div><?php get_footer(); ?>
