<?php
/**
 * Archive template for vehicles
 *
 * @package Vehizo
 * @version 4.1.3
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

get_header(); ?>

<div class="vehizo-archive-container">
    <header class="page-header">
        <h1 class="page-title"><?php esc_html_e('Vehicles', 'vehizo-vehicle-management'); ?></h1>
    </header>

    <main class="site-main">
        <?php if (have_posts()) : ?>
            <div class="vehizo-vehicles-grid">
                <?php while (have_posts()) : the_post(); ?>
                    <div class="vehizo-vehicle-card">
                        <div class="card-image">
                            <?php
                            // Get image URL - first try featured image, then gallery images
                            $image_url = '';
                            if (has_post_thumbnail()) {
                                $image_url = get_the_post_thumbnail_url(get_the_ID(), 'large');
                            } else {
                                // Try gallery images
                                $gallery = get_post_meta(get_the_ID(), 'vehizo_gallery', true);
                                if (!empty($gallery)) {
                                    $gallery_ids = explode(',', $gallery);
                                    $first_image_id = !empty($gallery_ids[0]) ? absint($gallery_ids[0]) : 0;
                                    if ($first_image_id) {
                                        $image_url = wp_get_attachment_image_url($first_image_id, 'large');
                                    }
                                }
                            }

                            if ($image_url) : ?>
                                <a href="<?php the_permalink(); ?>">
                                    <img src="<?php echo esc_url($image_url); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" loading="lazy">
                                </a>
                            <?php else : ?>
                                <div class="no-image">🚗</div>
                            <?php endif; ?>

                            <?php
                            // Show price badge
                            $price = get_post_meta(get_the_ID(), 'vehizo_price', true);
                            if (!empty($price) && is_numeric($price)) :
                                $currency_symbol = get_option('vehizo_currency_symbol', '€');
                                $currency_position = get_option('vehizo_currency_position', 'after');
                                if ($currency_position === 'before') {
                                    $formatted_price = $currency_symbol . ' ' . number_format_i18n((int)$price);
                                } else {
                                    $formatted_price = number_format_i18n((int)$price) . ' ' . $currency_symbol;
                                }
                            ?>
                                <div class="price-badge"><?php echo esc_html($formatted_price); ?></div>
                            <?php endif; ?>
                        </div>

                        <div class="card-content">
                            <h3 class="card-title">
                                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                            </h3>

                            <div class="specs-list">
                                <?php
                                $year = get_post_meta(get_the_ID(), 'vehizo_firstRegistration', true);
                                $mileage = get_post_meta(get_the_ID(), 'vehizo_mileage', true);
                                $power = get_post_meta(get_the_ID(), 'vehizo_power', true);
                                $transmission = get_post_meta(get_the_ID(), 'vehizo_transmission', true);
                                ?>

                                <?php if ($year) : ?>
                                    <div class="spec-row">
                                        <span class="spec-label"><?php esc_html_e('Year', 'vehizo-vehicle-management'); ?></span>
                                        <span class="spec-value"><?php echo esc_html($year); ?></span>
                                    </div>
                                <?php endif; ?>

                                <?php if ($mileage) : ?>
                                    <div class="spec-row">
                                        <span class="spec-label"><?php esc_html_e('Mileage', 'vehizo-vehicle-management'); ?></span>
                                        <span class="spec-value"><?php echo esc_html(number_format_i18n((int)$mileage)); ?> km</span>
                                    </div>
                                <?php endif; ?>

                                <?php if ($power) : ?>
                                    <div class="spec-row">
                                        <span class="spec-label"><?php esc_html_e('Power', 'vehizo-vehicle-management'); ?></span>
                                        <span class="spec-value"><?php echo esc_html($power); ?> PS</span>
                                    </div>
                                <?php endif; ?>

                                <?php if ($transmission) : ?>
                                    <div class="spec-row">
                                        <span class="spec-label"><?php esc_html_e('Transmission', 'vehizo-vehicle-management'); ?></span>
                                        <span class="spec-value"><?php echo esc_html($transmission); ?></span>
                                    </div>
                                <?php endif; ?>
                            </div>

                            <a href="<?php the_permalink(); ?>" class="cta-button">
                                <span><?php esc_html_e('View Details', 'vehizo-vehicle-management'); ?></span>
                                <span class="cta-arrow">→</span>
                            </a>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>

            <?php
            // Pagination
            $pagination_args = array(
                'prev_next' => false
            );
            echo '<div class="vehizo-pagination">' . wp_kses_post(paginate_links($pagination_args)) . '</div>';
            ?>

        <?php else : ?>
            <div class="no-results">
                <h3><?php esc_html_e('No vehicles found', 'vehizo-vehicle-management'); ?></h3>
            </div>
        <?php endif; ?>
    </main>
</div>

<?php get_footer(); ?>