/**
 * Vehizo Wishlist Counter Initialization
 *
 * @package Vehizo
 * @version 4.1.3
 */

document.addEventListener('DOMContentLoaded', function() {
    // Wait for the main JS to load, then override the counter function
    setTimeout(function() {

        // Create a unified counter update function
        window.updateWishlistCounterUnified = function() {

            try {
                const STORAGE_KEY = 'vehizo_wishlist_vehicles';
                const stored = localStorage.getItem(STORAGE_KEY);

                let wishlist = stored ? JSON.parse(stored) : [];

                // Validate and clean wishlist - remove invalid entries
                const originalLength = wishlist.length;
                wishlist = wishlist.filter(id => {
                    const isValid = Number.isInteger(id) && id > 0;
                    if (!isValid) {
                    }
                    return isValid;
                });

                // Remove duplicates
                wishlist = [...new Set(wishlist)];

                // Save cleaned wishlist back if it changed
                if (wishlist.length !== originalLength || JSON.stringify(wishlist) !== stored) {
                    localStorage.setItem(STORAGE_KEY, JSON.stringify(wishlist));
                }

                const count = wishlist.length;

                const counterElements = document.querySelectorAll('.wishlist-count');

                counterElements.forEach(counter => {
                    counter.textContent = `(${count})`;
                });

                return count;

            } catch (e) {
                // Clear corrupted data
                localStorage.removeItem('vehizo_wishlist_vehicles');
                const counterElements = document.querySelectorAll('.wishlist-count');
                counterElements.forEach(counter => {
                    counter.textContent = '(0)';
                });
                return 0;
            }
        };

        // Override the existing function
        window.updateWishlistCounter = window.updateWishlistCounterUnified;

        // Run the unified counter update
        window.updateWishlistCounterUnified();

    }, 600); // Wait for main JS to initialize
});