/**
 * Vehizo Statistics Charts
 * Chart.js initialization for vehicle statistics
 */

// Der 'DOMContentLoaded' Event Listener wurde entfernt, um das Timing-Problem zu beheben.

if (typeof Chart !== 'undefined' && typeof window.vehizoStatsData !== 'undefined') {
    Chart.defaults.font.family = "-apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif";
    Chart.defaults.color = '#6c757d';

    // Brands Chart (Doughnut)
    const brandsCtx = document.getElementById('brandsChart');
    if (brandsCtx && Object.keys(vehizoStatsData.brands).length > 0) {
        new Chart(brandsCtx.getContext('2d'), {
            type: 'doughnut',
            data: {
                labels: Object.keys(vehizoStatsData.brands),
                datasets: [{
                    data: Object.values(vehizoStatsData.brands),
                    backgroundColor: vehizoStatsData.chartColors,
                    borderWidth: 0,
                    hoverBorderWidth: 2,
                    hoverBorderColor: '#fff'
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'bottom',
                        labels: { 
                            padding: 20, 
                            usePointStyle: true, 
                            pointStyle: 'circle', 
                            font: { size: 13, weight: '500' } 
                        }
                    }
                }
            }
        });
    }

    // Fuel Types Chart (Pie)
    const fuelCtx = document.getElementById('fuelChart');
    if (fuelCtx && Object.keys(vehizoStatsData.fuelTypes).length > 0) {
        new Chart(fuelCtx.getContext('2d'), {
            type: 'pie',
            data: {
                labels: Object.keys(vehizoStatsData.fuelTypes),
                datasets: [{
                    data: Object.values(vehizoStatsData.fuelTypes),
                    backgroundColor: vehizoStatsData.chartColors,
                    borderWidth: 0
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: { 
                    legend: { 
                        position: 'bottom', 
                        labels: { 
                            padding: 15, 
                            usePointStyle: true, 
                            pointStyle: 'circle' 
                        } 
                    } 
                }
            }
        });
    }

    // Vehicle Types Chart (Bar)
    const vehicleTypesCtx = document.getElementById('vehicleTypesChart');
    if (vehicleTypesCtx && Object.keys(vehizoStatsData.vehicleTypes).length > 0) {
        new Chart(vehicleTypesCtx.getContext('2d'), {
            type: 'bar',
            data: {
                labels: Object.keys(vehizoStatsData.vehicleTypes),
                datasets: [{
                    data: Object.values(vehizoStatsData.vehicleTypes),
                    backgroundColor: '#4285f4',
                    borderRadius: 4,
                    borderSkipped: false
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: { legend: { display: false } },
                scales: { 
                    y: { beginAtZero: true, ticks: { precision: 0 } }, 
                    x: { ticks: { maxRotation: 45 } } 
                }
            }
        });
    }

    // Transmission Chart (Polar Area)
    const transmissionCtx = document.getElementById('transmissionChart');
    if (transmissionCtx && Object.keys(vehizoStatsData.transmissions).length > 0) {
        new Chart(transmissionCtx.getContext('2d'), {
            type: 'polarArea',
            data: {
                labels: Object.keys(vehizoStatsData.transmissions),
                datasets: [{
                    data: Object.values(vehizoStatsData.transmissions),
                    backgroundColor: vehizoStatsData.chartColors.map(color => color + 'CC'), // Add transparency
                    borderColor: vehizoStatsData.chartColors,
                    borderWidth: 2
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: { 
                    legend: { 
                        position: 'bottom', 
                        labels: { 
                            padding: 15, 
                            usePointStyle: true 
                        } 
                    } 
                },
                scales: { 
                    r: { 
                        beginAtZero: true, 
                        ticks: { precision: 0 } 
                    } 
                }
            }
        });
    }

    // Price Range Chart (Horizontal Bar)
    const priceRangeCtx = document.getElementById('priceRangeChart');
    if (priceRangeCtx && vehizoStatsData.priceRanges.some(val => val > 0)) {
        new Chart(priceRangeCtx.getContext('2d'), {
            type: 'bar',
            data: {
                labels: ['0-10k €', '10k-25k €', '25k-50k €', '50k-100k €', '100k+ €'],
                datasets: [{
                    data: vehizoStatsData.priceRanges,
                    backgroundColor: vehizoStatsData.chartColors.slice(0, 5),
                    borderRadius: 4,
                    borderSkipped: false
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                indexAxis: 'y',
                plugins: { legend: { display: false } },
                scales: {
                    x: {
                        beginAtZero: true,
                        ticks: { precision: 0 }
                    }
                }
            }
        });
    }

    // Price Distribution Chart (Bar)
    const priceDistributionCtx = document.getElementById('priceDistributionChart');
    if (priceDistributionCtx && vehizoStatsData.priceRanges.some(val => val > 0)) {
        new Chart(priceDistributionCtx.getContext('2d'), {
            type: 'bar',
            data: {
                labels: ['0-10k €', '10k-25k €', '25k-50k €', '50k-100k €', '100k+ €'],
                datasets: [{
                    label: 'Number of Vehicles',
                    data: vehizoStatsData.priceRanges,
                    backgroundColor: '#4285f4',
                    borderRadius: 6,
                    borderSkipped: false
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: { display: false },
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                return context.parsed.y + ' vehicles';
                            }
                        }
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: { precision: 0 },
                        grid: { color: '#f3f4f6' }
                    },
                    x: {
                        grid: { display: false }
                    }
                }
            }
        });
    }

    // Brand Distribution Chart (Doughnut)
    const brandDistributionCtx = document.getElementById('brandDistributionChart');
    if (brandDistributionCtx && Object.keys(vehizoStatsData.brands).length > 0) {
        new Chart(brandDistributionCtx.getContext('2d'), {
            type: 'doughnut',
            data: {
                labels: Object.keys(vehizoStatsData.brands),
                datasets: [{
                    data: Object.values(vehizoStatsData.brands),
                    backgroundColor: vehizoStatsData.chartColors,
                    borderWidth: 2,
                    borderColor: '#fff',
                    hoverBorderWidth: 3,
                    hoverBorderColor: '#fff'
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'right',
                        labels: {
                            padding: 15,
                            usePointStyle: true,
                            pointStyle: 'circle',
                            font: { size: 12, weight: '500' },
                            generateLabels: function(chart) {
                                const data = chart.data;
                                if (data.labels.length && data.datasets.length) {
                                    return data.labels.map((label, i) => {
                                        const value = data.datasets[0].data[i];
                                        return {
                                            text: label + ' (' + value + ')',
                                            fillStyle: data.datasets[0].backgroundColor[i],
                                            hidden: false,
                                            index: i
                                        };
                                    });
                                }
                                return [];
                            }
                        }
                    },
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                const label = context.label || '';
                                const value = context.parsed;
                                const total = context.dataset.data.reduce((a, b) => a + b, 0);
                                const percentage = ((value / total) * 100).toFixed(1);
                                return label + ': ' + value + ' (' + percentage + '%)';
                            }
                        }
                    }
                }
            }
        });
    }
}